/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.Cod;
import org.bukkit.entity.Fish;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.TropicalFish;
import org.eclipse.jdt.annotation.Nullable;

public class FishData
extends EntityData<Fish> {
    private boolean init = true;
    private boolean wildcard = false;
    private int pattern = -1;

    static {
        if (Skript.isRunningMinecraft(1, 13)) {
            FishData.register(FishData.class, "fish", Fish.class, 0, "fish", "cod", "puffer fish", "salmon", "tropical fish");
        }
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 0) {
            this.wildcard = true;
        }
        this.pattern = matchedPattern == 0 ? ThreadLocalRandom.current().nextInt(1, 5) : matchedPattern;
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Fish> c, @Nullable Fish e) {
        int matchedPattern = FishData.getInitPattern(e);
        if (matchedPattern == 0) {
            this.wildcard = true;
        }
        this.pattern = matchedPattern == 0 ? ThreadLocalRandom.current().nextInt(1, 5) : matchedPattern;
        return true;
    }

    @Override
    public void set(Fish entity) {
    }

    @Override
    protected boolean match(Fish entity) {
        return this.wildcard ? true : this.getPattern(entity) == this.pattern;
    }

    @Override
    public Class<? extends Fish> getType() {
        if (!this.init && this.wildcard) {
            return Fish.class;
        }
        this.init = false;
        switch (this.pattern) {
            case 1: {
                return Cod.class;
            }
            case 2: {
                return PufferFish.class;
            }
            case 3: {
                return Salmon.class;
            }
            case 4: {
                return TropicalFish.class;
            }
        }
        return Fish.class;
    }

    @Override
    public EntityData getSuperType() {
        return new FishData();
    }

    @Override
    protected int hashCode_i() {
        return this.wildcard ? 0 : this.pattern;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        return obj instanceof Fish ? (this.wildcard ? true : this.getPattern((Fish)obj) == this.pattern) : false;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        return e instanceof Fish ? (this.wildcard ? true : this.getPattern((Fish)e) == this.pattern) : false;
    }

    private static int getInitPattern(@Nullable Fish f) {
        if (f == null) {
            return 0;
        }
        if (f instanceof Cod) {
            return 1;
        }
        if (f instanceof PufferFish) {
            return 2;
        }
        if (f instanceof Salmon) {
            return 3;
        }
        if (f instanceof TropicalFish) {
            return 4;
        }
        return 0;
    }

    private int getPattern(@Nullable Fish f) {
        int p = FishData.getInitPattern(f);
        return p == 0 ? this.pattern : p;
    }
}

