/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Silence Entity")
@Description(value={"Controls whether or not an entity is silent."})
@Examples(value={"make target entity silent"})
@Since(value="2.5")
public class EffSilence
extends Effect {
    private Expression<Entity> entities;
    private boolean silence;

    static {
        Skript.registerEffect(EffSilence.class, "silence %entities%", "unsilence %entities%", "make %entities% silent", "make %entities% not silent");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.silence = matchedPattern % 2 == 0;
        return true;
    }

    @Override
    protected void execute(Event e) {
        Entity[] entityArray = this.entities.getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            entity.setSilent(this.silence);
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.silence ? "silence " : "unsilence ") + this.entities.toString(e, debug);
    }
}

