/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Make Invulnerable")
@Description(value={"Makes an entity invulnerable/not invulnerable."})
@Examples(value={"make target entity invulnerable"})
@Since(value="2.5")
public class EffInvulnerability
extends Effect {
    private Expression<Entity> entities;
    private boolean invulnerable;

    static {
        Skript.registerEffect(EffInvulnerability.class, "make %entities% invulnerable", "make %entities% (not invulnerable|vulnerable)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.entities = exprs[0];
        this.invulnerable = matchedPattern == 0;
        return true;
    }

    @Override
    protected void execute(Event e) {
        Entity[] entityArray = this.entities.getArray(e);
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            entity.setInvulnerable(this.invulnerable);
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "make " + this.entities.toString(e, debug) + (this.invulnerable ? " invulnerable" : " not invulnerable");
    }
}

