/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Starts/Ends With")
@Description(value={"Checks if a text starts or ends with another."})
@Examples(value={"if the argument starts with \"test\":", "\tsend \"Stop!\""})
@Since(value="2.2-dev36")
public class CondStartsEndsWith
extends Condition {
    private Expression<String> strings;
    private Expression<String> affix;
    private boolean usingEnds;

    static {
        Skript.registerCondition(CondStartsEndsWith.class, "%strings% (start|1\u00a6end)[s] with %string%", "%strings% (doesn't|does not|do not|don't) (start|1\u00a6end) with %string%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.strings = exprs[0];
        this.affix = exprs[1];
        this.usingEnds = parseResult.mark == 1;
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        String affix = this.affix.getSingle(e);
        if (affix == null) {
            return false;
        }
        return this.strings.check(e, string2 -> this.usingEnds ? string2.endsWith(affix) : string2.startsWith(affix), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.isNegated()) {
            return String.valueOf(this.strings.toString(e, debug)) + " doesn't " + (this.usingEnds ? "end" : "start") + " with " + this.affix.toString(e, debug);
        }
        return String.valueOf(this.strings.toString(e, debug)) + (this.usingEnds ? " ends" : " starts") + " with " + this.affix.toString(e, debug);
    }
}

