/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.LivingEntity;

@Name(value="Ignition Process")
@Description(value={"Checks if a creeper is going to explode."})
@Examples(value={"if the last spawned creeper is going to explode:", "\tloop all players in radius 3 of the last spawned creeper", "\t\tsend \"RUN!!!\" to the loop-player"})
@Since(value="2.5")
@RequiredPlugins(value={"Paper 1.13 or newer"})
public class CondIgnitionProcess
extends PropertyCondition<LivingEntity> {
    static {
        if (Skript.methodExists(Creeper.class, "isIgnited", new Class[0])) {
            Skript.registerCondition(CondIgnitionProcess.class, "[creeper[s]] %livingentities% ((is|are)|1\u00a6(isn't|is not|aren't|are not)) going to explode", "[creeper[s]] %livingentities% ((is|are)|1\u00a6(isn't|is not|aren't|are not)) in the (ignition|explosion) process", "creeper[s] %livingentities% ((is|are)|1\u00a6(isn't|is not|aren't|are not)) ignited");
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.setNegated(parseResult.mark == 1);
        return true;
    }

    @Override
    public boolean check(LivingEntity e) {
        return e instanceof Creeper && ((Creeper)e).isIgnited();
    }

    @Override
    protected String getPropertyName() {
        return "going to explode";
    }
}

