/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.aliases;

import ch.njol.skript.Skript;
import java.util.ArrayList;
import org.bukkit.Material;

public class MaterialRegistry {
    private static final boolean newMaterials = Skript.isRunningMinecraft(1, 13);
    private Material[] materials;
    private int[] ids;

    public static MaterialRegistry load(String[] names) {
        Material[] materials = Material.values();
        ArrayList<Material> mappings = new ArrayList<Material>(materials.length);
        boolean[] processed = new boolean[materials.length];
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (name != null) {
                Material mat;
                if (newMaterials) {
                    mat = Material.getMaterial((String)name);
                    if (mat == null) {
                        mat = Material.getMaterial((String)name, (boolean)true);
                    }
                } else {
                    mat = Material.valueOf((String)name);
                }
                mappings.add(mat);
                if (mat != null) {
                    processed[mat.ordinal()] = true;
                }
            }
            ++i;
        }
        if (names.length < materials.length) {
            Material[] materialArray = materials;
            int n = materials.length;
            int n2 = 0;
            while (n2 < n) {
                Material mat = materialArray[n2];
                if (!processed[mat.ordinal()]) {
                    mappings.add(mat);
                }
                ++n2;
            }
        }
        return new MaterialRegistry(mappings.toArray(new Material[mappings.size()]));
    }

    public MaterialRegistry(Material[] materials) {
        this.materials = materials;
        this.ids = new int[materials.length];
        int i = 0;
        while (i < materials.length) {
            Material m = materials[i];
            if (m != null) {
                this.ids[m.ordinal()] = i;
            }
            ++i;
        }
    }

    public MaterialRegistry() {
        this(Material.values());
    }

    public Material getMaterial(int id) {
        try {
            Material m = this.materials[id];
            assert (m != null);
            return m;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid material id");
        }
    }

    public int getId(Material material) {
        try {
            return this.ids[material.ordinal()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AssertionError((Object)"material registry out-of-date");
        }
    }

    public Material[] getMaterials() {
        return this.materials;
    }
}

