/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Message;
import ch.njol.skript.update.ReleaseManifest;
import ch.njol.skript.update.ReleaseStatus;
import ch.njol.skript.update.UpdateManifest;
import ch.njol.skript.update.Updater;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.ChatMessages;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.command.CommandSender;

public class SkriptUpdater
extends Updater {
    public static final Message m_not_started = new Message("updater.not started");
    public static final Message m_checking = new Message("updater.checking");
    public static final Message m_check_in_progress = new Message("updater.check in progress");
    public static final Message m_updater_disabled = new Message("updater.updater disabled");
    public static final ArgsMessage m_check_error = new ArgsMessage("updater.check error");
    public static final Message m_running_latest_version = new Message("updater.running latest version");
    public static final Message m_running_latest_version_beta = new Message("updater.running latest version (beta)");
    public static final ArgsMessage m_update_available = new ArgsMessage("updater.update available");
    public static final ArgsMessage m_downloading = new ArgsMessage("updater.downloading");
    public static final Message m_download_in_progress = new Message("updater.download in progress");
    public static final ArgsMessage m_download_error = new ArgsMessage("updater.download error");
    public static final ArgsMessage m_downloaded = new ArgsMessage("updater.downloaded");
    public static final Message m_internal_error = new Message("updater.internal error");
    public static final Message m_custom_version = new Message("updater.custom version");

    SkriptUpdater() {
        super(SkriptUpdater.loadManifest());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ReleaseManifest loadManifest() {
        String manifest;
        block15: {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try {
                    InputStream is = Skript.getInstance().getResource("release-manifest.json");
                    try {
                        try (Scanner s = new Scanner(is);){
                            s.useDelimiter("\\\\A");
                            manifest = s.next();
                        }
                        if (is == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Skript is missing release-manifest.json!");
            }
        }
        if ($assertionsDisabled) return ReleaseManifest.load(manifest);
        if (manifest != null) return ReleaseManifest.load(manifest);
        throw new AssertionError();
    }

    public CompletableFuture<Void> updateCheck(CommandSender sender) {
        CompletionStage future = this.checkUpdates().thenAccept(none -> {
            ReleaseStatus status = this.getReleaseStatus();
            switch (status) {
                case CUSTOM: {
                    Skript.info(sender, "" + m_custom_version);
                    break;
                }
                case LATEST: {
                    Skript.info(sender, "" + m_running_latest_version);
                    break;
                }
                case OUTDATED: {
                    UpdateManifest update = this.getUpdateManifest();
                    assert (update != null);
                    Skript.info(sender, m_update_available.toString(update.id, Skript.getVersion()));
                    sender.spigot().sendMessage(BungeeConverter.convert(ChatMessages.parseToArray("Download it at: <aqua><u><link:" + update.downloadUrl + ">" + update.downloadUrl)));
                    break;
                }
                case UNKNOWN: {
                    if (this.isEnabled()) {
                        Skript.error(sender, "" + m_internal_error);
                        break;
                    }
                    Skript.info(sender, "" + m_updater_disabled);
                }
            }
        });
        assert (future != null);
        return future;
    }

    public CompletableFuture<Void> changesCheck(CommandSender sender) {
        CompletionStage future = this.updateCheck(sender).thenAccept(none -> {
            UpdateManifest update;
            if (this.getReleaseStatus() == ReleaseStatus.OUTDATED && (update = this.getUpdateManifest()) != null) {
                sender.sendMessage("");
                Skript.info(sender, "Patch notes:");
                String[] stringArray = update.patchNotes.split("\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    String processed = line = line.replace("\r", "");
                    int start = line.indexOf(35);
                    while (start != -1) {
                        StringBuilder issue = new StringBuilder();
                        int i = start + 1;
                        while (i < line.length()) {
                            int c = line.codePointAt(i);
                            if (!Character.isDigit(c)) break;
                            issue.appendCodePoint(c);
                            i += Character.charCount(c);
                        }
                        if (issue.length() > 0) {
                            processed = processed.replace("#" + issue, "<aqua><u><link:https://github.com/SkriptLang/Skript/issues/" + issue + ">#" + issue + "<r>");
                        }
                        start = line.indexOf(35, start + 1);
                    }
                    line = processed;
                    assert (line != null);
                    sender.spigot().sendMessage(BungeeConverter.convert(ChatMessages.parseToArray(line)));
                    ++n2;
                }
            }
        });
        assert (future != null);
        return future;
    }
}

