/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.tests.platform;

import ch.njol.skript.tests.TestResults;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class Environment {
    private final String name;
    private final List<Resource> resources;
    private final List<Resource> downloads;
    private final String skriptTarget;
    private final String[] commandLine;

    public Environment(String name, List<Resource> resources, List<Resource> downloads, String skriptTarget, String ... commandLine) {
        this.name = name;
        this.resources = resources;
        this.downloads = downloads;
        this.skriptTarget = skriptTarget;
        this.commandLine = commandLine;
    }

    public String getName() {
        return this.name;
    }

    public void initialize(Path dataRoot, Path runnerRoot, boolean remake) throws IOException {
        Path target;
        Path env = runnerRoot.resolve(this.name);
        boolean onlyCopySkript = Files.exists(env, new LinkOption[0]) && !remake;
        Path skript = env.resolve(this.skriptTarget);
        Files.createDirectories(skript.getParent(), new FileAttribute[0]);
        try {
            Files.copy(new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toPath(), skript, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        if (onlyCopySkript) {
            return;
        }
        for (Resource resource : this.resources) {
            Path source = dataRoot.resolve(resource.getSource());
            target = env.resolve(resource.getTarget());
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        for (Resource resource : this.downloads) {
            assert (resource != null);
            URL url = new URL(resource.getSource());
            target = env.resolve(resource.getTarget());
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Throwable throwable = null;
            Object var12_14 = null;
            try (InputStream is = url.openStream();){
                Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public TestResults runTests(Path runnerRoot, Path testsRoot, boolean devMode, String ... jvmArgs) throws IOException, InterruptedException {
        int code;
        Path env = runnerRoot.resolve(this.name);
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        args.add("-ea");
        args.add("-Dskript.testing.enabled=true");
        args.add("-Dskript.testing.dir=" + testsRoot);
        args.add("-Dskript.testing.devMode=" + devMode);
        args.add("-Dskript.testing.results=test_results.json");
        args.addAll(Arrays.asList(jvmArgs));
        args.addAll(Arrays.asList(this.commandLine));
        final Process process = new ProcessBuilder(args).directory(env.toFile()).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).redirectInput(ProcessBuilder.Redirect.INHERIT).start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (process.isAlive()) {
                process.destroy();
            }
        }));
        if (!devMode) {
            new Timer("runner watchdog", true).schedule(new TimerTask(){

                @Override
                public void run() {
                    if (process.isAlive()) {
                        System.err.println("Test environment is taking too long, failing...");
                        System.exit(1);
                    }
                }
            }, 480000L);
        }
        if ((code = process.waitFor()) != 0) {
            throw new IOException("environment returned with code " + code);
        }
        TestResults results = (TestResults)new Gson().fromJson(new String(Files.readAllBytes(env.resolve("test_results.json"))), TestResults.class);
        assert (results != null);
        return results;
    }

    public static class Resource {
        private String source;
        private String target;

        public Resource(String url, String target) {
            this.source = url;
            this.target = target;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }
    }
}

