/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.function.ExprFunctionCall;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.ScriptOptions;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class SkriptParser {
    final String expr;
    public static final int PARSE_EXPRESSIONS = 1;
    public static final int PARSE_LITERALS = 2;
    public static final int ALL_FLAGS = 3;
    private final int flags;
    public final ParseContext context;
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    public static final String stringMatcher = "\"[^\"]*?(?:\"\"[^\"]*)*?\"";
    private static final Pattern varPattern = Pattern.compile("((the )?var(iable)? )?\\{([^{}]|%\\{|\\}%)+\\}", 2);
    public static final Pattern listSplitPattern = Pattern.compile("\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*", 2);
    private static final String MULTIPLE_AND_OR = "List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists.";
    private static final String MISSING_AND_OR = "List is missing 'and' or 'or', defaulting to 'and'";
    private boolean suppressMissingAndOrWarnings = SkriptConfig.disableMissingAndOrWarnings.value();
    private static final Pattern functionCallPattern = Pattern.compile("([\\p{IsAlphabetic}][\\p{IsAlphabetic}\\p{IsDigit}_]*)\\((.*)\\)");
    private static final Message m_quotes_error = new Message("skript.quotes error");
    private static final Message m_brackets_error = new Message("skript.brackets error");
    private static final Map<String, ExprInfo> exprInfoCache = new HashMap<String, ExprInfo>();

    public SkriptParser(String expr) {
        this(expr, 3);
    }

    public SkriptParser(String expr, int flags) {
        this(expr, flags, ParseContext.DEFAULT);
    }

    public SkriptParser(String expr, int flags, ParseContext context) {
        assert (expr != null);
        assert ((flags & 3) != 0);
        this.expr = expr.trim();
        this.flags = flags;
        this.context = context;
    }

    public SkriptParser(SkriptParser other, String expr) {
        this(expr, other.flags, other.context);
    }

    @Nullable
    public static <T> Literal<? extends T> parseLiteral(String expr, Class<T> c, ParseContext context) {
        if ((expr = expr.trim()).isEmpty()) {
            return null;
        }
        return new UnparsedLiteral(expr).getConvertedExpression(context, c);
    }

    @Nullable
    public static <T extends SyntaxElement> T parse(String expr, Iterator<? extends SyntaxElementInfo<T>> source, @Nullable String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T e = new SkriptParser(expr).parse(source);
            if (e != null) {
                log.printLog();
                T t = e;
                return t;
            }
            log.printError(defaultError);
            return null;
        }
        finally {
            log.stop();
        }
    }

    @Nullable
    public static <T extends SyntaxElement> T parseStatic(String expr, Iterator<? extends SyntaxElementInfo<? extends T>> source, @Nullable String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T e = new SkriptParser(expr, 2).parse(source);
            if (e != null) {
                log.printLog();
                T t = e;
                return t;
            }
            log.printError(defaultError);
            return null;
        }
        finally {
            log.stop();
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private final <T extends SyntaxElement> T parse(Iterator<? extends SyntaxElementInfo<? extends T>> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static <T> Variable<T> parseVariable(String expr, Class<? extends T>[] returnTypes) {
        if (varPattern.matcher(expr).matches()) {
            return Variable.newInstance(expr.substring(expr.indexOf(123) + 1, expr.lastIndexOf(125)), returnTypes);
        }
        return null;
    }

    @Nullable
    private final <T> Expression<? extends T> parseSingleExpr(boolean allowUnparsedLiteral, @Nullable LogEntry error, Class<? extends T> ... types) {
        assert (types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.context != ParseContext.COMMAND && this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
            return new SkriptParser(this, this.expr.substring(1, this.expr.length() - 1)).parseSingleExpr(allowUnparsedLiteral, error, types);
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression<String> e;
            if (this.context == ParseContext.DEFAULT || this.context == ParseContext.EVENT) {
                Variable<? extends T> var = SkriptParser.parseVariable(this.expr, types);
                if (var != null) {
                    if ((this.flags & 1) == 0) {
                        Skript.error("Variables cannot be used here.");
                        log.printError();
                        return null;
                    }
                    log.printLog();
                    Variable<? extends T> variable = var;
                    return variable;
                }
                if (log.hasError()) {
                    log.printError();
                    return null;
                }
                FunctionReference<? extends T> fr = this.parseFunction(types);
                if (fr != null) {
                    log.printLog();
                    ExprFunctionCall<? extends T> exprFunctionCall = new ExprFunctionCall<T>(fr);
                    return exprFunctionCall;
                }
                if (log.hasError()) {
                    log.printError();
                    return null;
                }
            }
            log.clear();
            if ((this.flags & 1) != 0) {
                e = this.expr.startsWith("\"") && this.expr.endsWith("\"") && this.expr.length() != 1 && (types[0] == Object.class || CollectionUtils.contains(types, String.class)) ? VariableString.newInstance(this.expr.substring(1, this.expr.length() - 1)) : (Expression)SkriptParser.parse(this.expr, Skript.getExpressions(types), null);
                if (e != null) {
                    Class<? extends T>[] classArray = types;
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<T> t = classArray[n2];
                        if (t.isAssignableFrom(e.getReturnType())) {
                            log.printLog();
                            Expression<String> expression = e;
                            return expression;
                        }
                        ++n2;
                    }
                    Class<? extends T>[] objTypes = types;
                    Expression<? extends T> r = e.getConvertedExpression(objTypes);
                    if (r != null) {
                        log.printLog();
                        Expression<? extends T> expression = r;
                        return expression;
                    }
                    log.printError(String.valueOf(e.toString(null, false)) + " " + Language.get("is") + " " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                    return null;
                }
                log.clear();
            }
            if ((this.flags & 2) == 0) {
                log.printError();
                return null;
            }
            if (types[0] == Object.class) {
                if (!allowUnparsedLiteral) {
                    log.printError();
                    return null;
                }
                log.clear();
                log.printLog();
                e = log.getError();
                UnparsedLiteral unparsedLiteral = new UnparsedLiteral(this.expr, (LogEntry)(e != null && (error == null || ((LogEntry)((Object)e)).quality > error.quality) ? e : error));
                return unparsedLiteral;
            }
            Class<? extends T>[] classArray = types;
            int n = types.length;
            int n3 = 0;
            while (n3 < n) {
                Class<? extends T> c = classArray[n3];
                log.clear();
                assert (c != null);
                T t = Classes.parse(this.expr, c, this.context);
                if (t != null) {
                    log.printLog();
                    SimpleLiteral<T> simpleLiteral = new SimpleLiteral<T>(t, false);
                    return simpleLiteral;
                }
                ++n3;
            }
            log.printError();
            return null;
        }
        finally {
            log.stop();
        }
    }

    @Nullable
    private final Expression<?> parseSingleExpr(boolean allowUnparsedLiteral, @Nullable LogEntry error, ExprInfo vi) {
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.context != ParseContext.COMMAND && this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
            return new SkriptParser(this, this.expr.substring(1, this.expr.length() - 1)).parseSingleExpr(allowUnparsedLiteral, error, vi);
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression<String> e;
            Class[] types = new Class[vi.classes.length];
            boolean hasSingular = false;
            boolean hasPlural = false;
            Class[] nonNullTypes = new Class[vi.classes.length];
            int nonNullIndex = 0;
            int i = 0;
            while (i < types.length) {
                if ((this.flags & vi.flagMask) != 0) {
                    if (vi.isPlural[i]) {
                        hasPlural = true;
                    } else {
                        hasSingular = true;
                    }
                    types[i] = vi.classes[i].getC();
                    nonNullTypes[nonNullIndex] = types[i];
                    ++nonNullIndex;
                }
                ++i;
            }
            boolean onlyPlural = false;
            boolean onlySingular = false;
            if (hasSingular && !hasPlural) {
                onlySingular = true;
            } else if (!hasSingular && hasPlural) {
                onlyPlural = true;
            }
            if (this.context == ParseContext.DEFAULT || this.context == ParseContext.EVENT) {
                FunctionReference fr;
                Variable var;
                if (onlySingular || onlyPlural) {
                    var = SkriptParser.parseVariable(this.expr, nonNullTypes);
                    if (var != null) {
                        if ((this.flags & 1) == 0) {
                            Skript.error("Variables cannot be used here.");
                            log.printError();
                            return null;
                        }
                        if (hasSingular && !var.isSingle()) {
                            Skript.error("'" + this.expr + "' can only accept a single value of any type, not more", ErrorQuality.SEMANTIC_ERROR);
                            return null;
                        }
                        log.printLog();
                        Variable variable = var;
                        return variable;
                    }
                    if (log.hasError()) {
                        log.printError();
                        return null;
                    }
                } else {
                    var = SkriptParser.parseVariable(this.expr, types);
                    if (var != null) {
                        if ((this.flags & 1) == 0) {
                            Skript.error("Variables cannot be used here.");
                            log.printError();
                            return null;
                        }
                        if ((vi.classes.length == 1 && !vi.isPlural[0] || Booleans.contains((boolean[])vi.isPlural, (boolean)true)) && !var.isSingle()) {
                            Skript.error("'" + this.expr + "' can only accept a single " + Classes.toString(Stream.of(vi.classes).map(ci -> ci.getName().toString()).toArray(), false) + ", not more", ErrorQuality.SEMANTIC_ERROR);
                            return null;
                        }
                        log.printLog();
                        Variable variable = var;
                        return variable;
                    }
                    if (log.hasError()) {
                        log.printError();
                        return null;
                    }
                }
                if ((fr = this.parseFunction(types)) != null) {
                    log.printLog();
                    ExprFunctionCall exprFunctionCall = new ExprFunctionCall(fr);
                    return exprFunctionCall;
                }
                if (log.hasError()) {
                    log.printError();
                    return null;
                }
            }
            log.clear();
            if ((this.flags & 1) != 0) {
                e = this.expr.startsWith("\"") && this.expr.endsWith("\"") && this.expr.length() != 1 && (types[0] == Object.class || CollectionUtils.contains(types, String.class)) ? VariableString.newInstance(this.expr.substring(1, this.expr.length() - 1)) : (Expression)SkriptParser.parse(this.expr, Skript.getExpressions(types), null);
                if (e != null) {
                    Class returnType = e.getReturnType();
                    assert (returnType != null);
                    int i2 = 0;
                    while (i2 < types.length) {
                        Class t = types[i2];
                        if (t != null && t.isAssignableFrom(returnType)) {
                            if (!vi.isPlural[i2] && !e.isSingle()) {
                                if (this.context == ParseContext.COMMAND) {
                                    Skript.error(Commands.m_too_many_arguments.toString(vi.classes[i2].getName().getIndefiniteArticle(), vi.classes[i2].getName().toString()), ErrorQuality.SEMANTIC_ERROR);
                                    return null;
                                }
                                Skript.error("'" + this.expr + "' can only accept a single " + vi.classes[i2].getName() + ", not more", ErrorQuality.SEMANTIC_ERROR);
                                return null;
                            }
                            log.printLog();
                            Expression<String> expression = e;
                            return expression;
                        }
                        ++i2;
                    }
                    if (types.length == 1) {
                        Expression r = e.getConvertedExpression(types);
                        if (r != null) {
                            log.printLog();
                            Expression expression = r;
                            return expression;
                        }
                    } else {
                        if (returnType == Object.class) {
                            log.printLog();
                            Expression<String> expression = e;
                            return expression;
                        }
                        Expression r = e.getConvertedExpression(types);
                        if (r != null) {
                            log.printLog();
                            Expression expression = r;
                            return expression;
                        }
                    }
                    log.printError(String.valueOf(e.toString(null, false)) + " " + Language.get("is") + " " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                    return null;
                }
                log.clear();
            }
            if ((this.flags & 2) == 0) {
                log.printError();
                return null;
            }
            if (vi.classes[0].getC() == Object.class) {
                if (!allowUnparsedLiteral) {
                    log.printError();
                    return null;
                }
                log.clear();
                log.printLog();
                e = log.getError();
                UnparsedLiteral unparsedLiteral = new UnparsedLiteral(this.expr, (LogEntry)(e != null && (error == null || ((LogEntry)((Object)e)).quality > error.quality) ? e : error));
                return unparsedLiteral;
            }
            ClassInfo<?>[] classInfoArray = vi.classes;
            int n = vi.classes.length;
            int n2 = 0;
            while (n2 < n) {
                ClassInfo<?> ci2 = classInfoArray[n2];
                log.clear();
                assert (ci2.getC() != null);
                Object t = Classes.parse(this.expr, ci2.getC(), this.context);
                if (t != null) {
                    log.printLog();
                    SimpleLiteral simpleLiteral = new SimpleLiteral(t, false, new UnparsedLiteral(this.expr));
                    return simpleLiteral;
                }
                ++n2;
            }
            log.printError();
            return null;
        }
        finally {
            log.stop();
        }
    }

    private SkriptParser suppressMissingAndOrWarnings() {
        this.suppressMissingAndOrWarnings = true;
        return this;
    }

    @Nullable
    public final <T> Expression<? extends T> parseExpression(Class<? extends T> ... types) {
        if (this.expr.length() == 0) {
            return null;
        }
        assert (types != null && types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        boolean isObject = types.length == 1 && types[0] == Object.class;
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            int a;
            Expression<? extends T> r;
            if (isObject && (this.flags & 2) != 0) {
                SkriptParser p = new SkriptParser(this.expr, 2, this.context);
                if (ScriptLoader.currentScript != null) {
                    Config cs = ScriptLoader.currentScript;
                    p.suppressMissingAndOrWarnings = ScriptOptions.getInstance().suppressesWarning(cs.getFile(), "conjunction");
                }
                if (!p.suppressMissingAndOrWarnings) {
                    p.suppressMissingAndOrWarnings = this.suppressMissingAndOrWarnings;
                }
                Class[] classArray = new Class[]{Number.class, Time.class, ItemType.class, ItemStack.class};
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class c = classArray[n2];
                    Expression<T> e = p.parseExpression(c);
                    if (e != null) {
                        log.printLog();
                        Expression<T> expression = e;
                        return expression;
                    }
                    log.clear();
                    ++n2;
                }
            }
            if ((r = this.parseSingleExpr(false, null, types)) != null) {
                log.printLog();
                Expression<? extends T> expression = r;
                return expression;
            }
            log.clear();
            ArrayList<Expression<? extends T>> ts = new ArrayList<Expression<? extends T>>();
            Kleenean and = Kleenean.UNKNOWN;
            boolean isLiteralList = true;
            ArrayList<int[]> pieces = new ArrayList<int[]>();
            Matcher m = listSplitPattern.matcher(this.expr);
            int i = 0;
            int j = 0;
            while (i >= 0 && i <= this.expr.length()) {
                if (i == this.expr.length() || m.region(i, this.expr.length()).lookingAt()) {
                    pieces.add(new int[]{j, i});
                    if (i == this.expr.length()) break;
                    j = i = m.end();
                }
                i = SkriptParser.next(this.expr, i, this.context);
            }
            if (i != this.expr.length()) {
                assert (i == -1 && this.context != ParseContext.COMMAND) : String.valueOf(i) + "; " + this.expr;
                log.printError("Invalid brackets/variables/text in '" + this.expr + "'", ErrorQuality.NOT_AN_EXPRESSION);
                return null;
            }
            if (pieces.size() == 1) {
                if (this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
                    log.clear();
                    log.printLog();
                    Expression<? extends T> expression = new SkriptParser(this, this.expr.substring(1, this.expr.length() - 1)).parseExpression(types);
                    return expression;
                }
                if (isObject && (this.flags & 2) != 0) {
                    log.clear();
                    log.printLog();
                    UnparsedLiteral unparsedLiteral = new UnparsedLiteral(this.expr, log.getError());
                    return unparsedLiteral;
                }
                log.printError();
                return null;
            }
            block14: for (int b = 0; b < pieces.size(); b += a) {
                a = pieces.size() - b;
                while (a >= 1) {
                    if (b != 0 || a != pieces.size()) {
                        int x = ((int[])pieces.get(b))[0];
                        int y = ((int[])pieces.get(b + a - 1))[1];
                        String subExpr = this.expr.substring(x, y).trim();
                        assert (subExpr.length() < this.expr.length()) : subExpr;
                        Expression<? extends T> t = subExpr.startsWith("(") && subExpr.endsWith(")") && SkriptParser.next(subExpr, 0, this.context) == subExpr.length() ? new SkriptParser(this, subExpr).parseExpression(types) : new SkriptParser(this, subExpr).parseSingleExpr(a == 1, log.getError(), types);
                        if (t != null) {
                            String d;
                            isLiteralList &= t instanceof Literal;
                            ts.add(t);
                            if (b == 0 || (d = this.expr.substring(((int[])pieces.get(b - 1))[1], x).trim()).equals(",")) continue block14;
                            if (and.isUnknown()) {
                                and = Kleenean.get(!d.equalsIgnoreCase("or"));
                                continue block14;
                            }
                            if (and == Kleenean.get(!d.equalsIgnoreCase("or"))) continue block14;
                            Skript.warning("List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists. List: " + this.expr);
                            and = Kleenean.TRUE;
                            continue block14;
                        }
                    }
                    --a;
                }
                log.printError();
                return null;
            }
            log.printLog();
            if (ts.size() == 1) {
                Expression expression = (Expression)ts.get(0);
                return expression;
            }
            if (and.isUnknown() && !this.suppressMissingAndOrWarnings) {
                if (ScriptLoader.currentScript != null) {
                    Config cs = ScriptLoader.currentScript;
                    if (!ScriptOptions.getInstance().suppressesWarning(cs.getFile(), "conjunction")) {
                        Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                    }
                } else {
                    Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                }
            }
            Class[] exprRetTypes = new Class[ts.size()];
            i = 0;
            while (i < ts.size()) {
                exprRetTypes[i] = ((Expression)ts.get(i)).getReturnType();
                ++i;
            }
            if (isLiteralList) {
                Literal[] ls = ts.toArray(new Literal[ts.size()]);
                assert (ls != null);
                LiteralList literalList = new LiteralList(ls, Utils.getSuperType(exprRetTypes), !and.isFalse());
                return literalList;
            }
            Expression[] es = ts.toArray(new Expression[ts.size()]);
            assert (es != null);
            ExpressionList expressionList = new ExpressionList(es, Utils.getSuperType(exprRetTypes), !and.isFalse());
            return expressionList;
        }
        finally {
            log.stop();
        }
    }

    @Nullable
    public final Expression<?> parseExpression(ExprInfo vi) {
        if (this.expr.length() == 0) {
            return null;
        }
        boolean isObject = vi.classes.length == 1 && vi.classes[0].getC() == Object.class;
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            int a;
            Expression<?> r;
            if (isObject && (this.flags & 2) != 0) {
                SkriptParser p = new SkriptParser(this.expr, 2, this.context);
                p.suppressMissingAndOrWarnings = this.suppressMissingAndOrWarnings;
                if (ScriptLoader.currentScript != null) {
                    Config cs = ScriptLoader.currentScript;
                    p.suppressMissingAndOrWarnings = ScriptOptions.getInstance().suppressesWarning(cs.getFile(), "conjunction");
                }
                Class[] classArray = new Class[]{Number.class, Time.class, ItemType.class, ItemStack.class};
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class c = classArray[n2];
                    Expression e = p.parseExpression(c);
                    if (e != null) {
                        log.printLog();
                        Expression expression = e;
                        return expression;
                    }
                    log.clear();
                    ++n2;
                }
            }
            if ((r = this.parseSingleExpr(false, null, vi)) != null) {
                log.printLog();
                Expression<?> expression = r;
                return expression;
            }
            log.clear();
            ArrayList ts = new ArrayList();
            Kleenean and = Kleenean.UNKNOWN;
            boolean isLiteralList = true;
            ArrayList<int[]> pieces = new ArrayList<int[]>();
            Matcher m = listSplitPattern.matcher(this.expr);
            int i = 0;
            int j = 0;
            while (i >= 0 && i <= this.expr.length()) {
                if (i == this.expr.length() || m.region(i, this.expr.length()).lookingAt()) {
                    pieces.add(new int[]{j, i});
                    if (i == this.expr.length()) break;
                    j = i = m.end();
                }
                i = SkriptParser.next(this.expr, i, this.context);
            }
            if (i != this.expr.length()) {
                assert (i == -1 && this.context != ParseContext.COMMAND) : String.valueOf(i) + "; " + this.expr;
                log.printError("Invalid brackets/variables/text in '" + this.expr + "'", ErrorQuality.NOT_AN_EXPRESSION);
                return null;
            }
            if (pieces.size() == 1) {
                if (this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
                    log.clear();
                    log.printLog();
                    Expression<?> expression = new SkriptParser(this, this.expr.substring(1, this.expr.length() - 1)).parseExpression(vi);
                    return expression;
                }
                if (isObject && (this.flags & 2) != 0) {
                    log.clear();
                    log.printLog();
                    UnparsedLiteral unparsedLiteral = new UnparsedLiteral(this.expr, log.getError());
                    return unparsedLiteral;
                }
                log.printError();
                return null;
            }
            block15: for (int b = 0; b < pieces.size(); b += a) {
                a = pieces.size() - b;
                while (a >= 1) {
                    if (b != 0 || a != pieces.size()) {
                        int x = ((int[])pieces.get(b))[0];
                        int y = ((int[])pieces.get(b + a - 1))[1];
                        String subExpr = this.expr.substring(x, y).trim();
                        assert (subExpr.length() < this.expr.length()) : subExpr;
                        Expression<?> t = subExpr.startsWith("(") && subExpr.endsWith(")") && SkriptParser.next(subExpr, 0, this.context) == subExpr.length() ? new SkriptParser(this, subExpr).parseExpression(vi) : new SkriptParser(this, subExpr).parseSingleExpr(a == 1, log.getError(), vi);
                        if (t != null) {
                            String d;
                            isLiteralList &= t instanceof Literal;
                            ts.add(t);
                            if (b == 0 || (d = this.expr.substring(((int[])pieces.get(b - 1))[1], x).trim()).equals(",")) continue block15;
                            if (and.isUnknown()) {
                                and = Kleenean.get(!d.equalsIgnoreCase("or"));
                                continue block15;
                            }
                            if (and == Kleenean.get(!d.equalsIgnoreCase("or"))) continue block15;
                            Skript.warning("List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists. List: " + this.expr);
                            and = Kleenean.TRUE;
                            continue block15;
                        }
                    }
                    --a;
                }
                log.printError();
                return null;
            }
            if (!vi.isPlural[0] && !and.isFalse()) {
                log.printError();
                return null;
            }
            log.printLog();
            if (ts.size() == 1) {
                Expression expression = (Expression)ts.get(0);
                return expression;
            }
            if (and.isUnknown() && !this.suppressMissingAndOrWarnings) {
                if (ScriptLoader.currentScript != null) {
                    Config cs = ScriptLoader.currentScript;
                    if (!ScriptOptions.getInstance().suppressesWarning(cs.getFile(), "conjunction")) {
                        Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                    }
                } else {
                    Skript.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
                }
            }
            Class[] exprRetTypes = new Class[ts.size()];
            i = 0;
            while (i < ts.size()) {
                exprRetTypes[i] = ((Expression)ts.get(i)).getReturnType();
                ++i;
            }
            if (isLiteralList) {
                Literal[] ls = ts.toArray(new Literal[ts.size()]);
                assert (ls != null);
                LiteralList literalList = new LiteralList(ls, Utils.getSuperType(exprRetTypes), !and.isFalse());
                return literalList;
            }
            Expression[] es = ts.toArray(new Expression[ts.size()]);
            assert (es != null);
            ExpressionList expressionList = new ExpressionList(es, Utils.getSuperType(exprRetTypes), !and.isFalse());
            return expressionList;
        }
        finally {
            log.stop();
        }
    }

    @Nullable
    public final <T> FunctionReference<T> parseFunction(Class<? extends T> ... types) {
        if (this.context != ParseContext.DEFAULT && this.context != ParseContext.EVENT) {
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression[] params;
            Matcher m = functionCallPattern.matcher(this.expr);
            if (!m.matches()) {
                log.printLog();
                return null;
            }
            if ((this.flags & 1) == 0) {
                Skript.error("Functions cannot be used here (or there is a problem with your arguments).");
                log.printError();
                return null;
            }
            String functionName = m.group(1);
            String args = m.group(2);
            if (args.length() != 0) {
                Expression<T> ps = new SkriptParser(args, this.flags | 2, this.context).suppressMissingAndOrWarnings().parseExpression(Object.class);
                if (ps == null) {
                    log.printError();
                    return null;
                }
                if (ps instanceof ExpressionList) {
                    if (!ps.getAnd()) {
                        Skript.error("Function arguments must be separated by commas and optionally an 'and', but not an 'or'. Put the 'or' into a second set of parentheses if you want to make it a single parameter, e.g. 'give(player, (sword or axe))'");
                        log.printError();
                        return null;
                    }
                    params = ((ExpressionList)ps).getExpressions();
                } else {
                    params = new Expression[]{ps};
                }
            } else {
                params = new Expression[]{};
            }
            FunctionReference<T> e = new FunctionReference<T>(functionName, SkriptLogger.getNode(), ScriptLoader.currentScript != null ? ScriptLoader.currentScript.getFileName() : null, types, params);
            if (!e.validateFunction(true)) {
                log.printError();
                return null;
            }
            log.printLog();
            FunctionReference<T> functionReference = e;
            return functionReference;
        }
        finally {
            log.stop();
        }
    }

    public static boolean parseArguments(String args, ScriptCommand command, ScriptCommandEvent event) {
        SkriptParser parser = new SkriptParser(args, 2, ParseContext.COMMAND);
        ParseResult res = parser.parse_i(command.getPattern(), 0, 0);
        if (res == null) {
            return false;
        }
        List<Argument<?>> as = command.getArguments();
        assert (as.size() == res.exprs.length);
        int i = 0;
        while (i < res.exprs.length) {
            if (res.exprs[i] == null) {
                as.get(i).setToDefault(event);
            } else {
                as.get(i).set(event, res.exprs[i].getArray(event));
            }
            ++i;
        }
        return true;
    }

    @Nullable
    public static ParseResult parse(String text, String pattern) {
        return new SkriptParser(text, 2, ParseContext.COMMAND).parse_i(pattern, 0, 0);
    }

    @Nullable
    public static NonNullPair<SkriptEventInfo<?>, SkriptEvent> parseEvent(String event, String defaultError) {
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        try {
            NonNullPair<SkriptEventInfo<?>, SkriptEvent> e = new SkriptParser(event, 2, ParseContext.EVENT).parseEvent();
            if (e != null) {
                log.printLog();
                NonNullPair<SkriptEventInfo<?>, SkriptEvent> nonNullPair = e;
                return nonNullPair;
            }
            log.printErrors(defaultError);
            return null;
        }
        finally {
            log.stop();
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private NonNullPair<SkriptEventInfo<?>, SkriptEvent> parseEvent() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int nextBracket(String pattern, char closingBracket, char openingBracket, int start, boolean isGroup) throws MalformedPatternException {
        int n = 0;
        int i = start;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == closingBracket) {
                if (n == 0) {
                    if (!isGroup) {
                        throw new MalformedPatternException(pattern, "Unexpected closing bracket '" + closingBracket + "'");
                    }
                    return i;
                }
                --n;
            } else if (pattern.charAt(i) == openingBracket) {
                ++n;
            }
            ++i;
        }
        if (isGroup) {
            throw new MalformedPatternException(pattern, "Missing closing bracket '" + closingBracket + "'");
        }
        return -1;
    }

    private static int nextUnescaped(String pattern, char c, int from) {
        int i = from;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int countUnescaped(String pattern, char c) {
        return SkriptParser.countUnescaped(pattern, c, 0, pattern.length());
    }

    static int countUnescaped(String pattern, char c, int start, int end) {
        assert (start >= 0 && start <= end && end <= pattern.length()) : String.valueOf(start) + ", " + end + "; " + pattern.length();
        int r = 0;
        int i = start;
        while (i < end) {
            char x = pattern.charAt(i);
            if (x == '\\') {
                ++i;
            } else if (x == c) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    private static int nextQuote(String s, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\"') {
                if (i == s.length() - 1 || s.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
            }
            ++i;
        }
        return -1;
    }

    public static String notOfType(Class<?> ... cs) {
        if (cs.length == 1) {
            Class<?> c = cs[0];
            assert (c != null);
            return String.valueOf(Language.get("not")) + " " + Classes.getSuperClassInfo(c).getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(String.valueOf(Language.get("neither")) + " ");
        int k = 0;
        while (k < cs.length) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            Class<?> c = cs[k];
            assert (c != null);
            b.append(Classes.getSuperClassInfo(c).getName().withIndefiniteArticle());
            ++k;
        }
        return b.toString();
    }

    public static String notOfType(ClassInfo<?> ... cs) {
        if (cs.length == 1) {
            return String.valueOf(Language.get("not")) + " " + cs[0].getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(String.valueOf(Language.get("neither")) + " ");
        int k = 0;
        while (k < cs.length) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            b.append(cs[k].getName().withIndefiniteArticle());
            ++k;
        }
        return b.toString();
    }

    public static int next(String expr, int i, ParseContext context) {
        if (i >= expr.length()) {
            return -1;
        }
        if (i < 0) {
            throw new StringIndexOutOfBoundsException(i);
        }
        if (context == ParseContext.COMMAND) {
            return i + 1;
        }
        char c = expr.charAt(i);
        if (c == '\"') {
            int i2 = SkriptParser.nextQuote(expr, i + 1);
            return i2 < 0 ? -1 : i2 + 1;
        }
        if (c == '{') {
            int i2 = VariableString.nextVariableBracket(expr, i + 1);
            return i2 < 0 ? -1 : i2 + 1;
        }
        if (c == '(') {
            int j = i + 1;
            while (j >= 0 && j < expr.length()) {
                if (expr.charAt(j) == ')') {
                    return j + 1;
                }
                j = SkriptParser.next(expr, j, context);
            }
            return -1;
        }
        return i + 1;
    }

    private static int getGroupLevel(String pattern, int j) {
        assert (j >= 0 && j <= pattern.length()) : String.valueOf(j) + "; " + pattern;
        int level = 0;
        int i = 0;
        while (i < j) {
            char c = pattern.charAt(i);
            if (c == '\\') {
                ++i;
            } else if (c == '(') {
                ++level;
            } else if (c == ')') {
                if (level == 0) {
                    throw new MalformedPatternException(pattern, "Unexpected closing bracket ')'");
                }
                --level;
            }
            ++i;
        }
        return level;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private final ParseResult parse_i(String pattern, int i, int j) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK], 6[TRYBLOCK]], but top level block is 55[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static NonNullPair<String, boolean[]> validatePattern(String pattern) {
        ArrayList<Boolean> ps = new ArrayList<Boolean>();
        int groupLevel = 0;
        int optionalLevel = 0;
        LinkedList<Character> groups = new LinkedList<Character>();
        StringBuilder b = new StringBuilder(pattern.length());
        int last = 0;
        int i = 0;
        while (i < pattern.length()) {
            int j;
            char c = pattern.charAt(i);
            if (c == '(') {
                ++groupLevel;
                groups.addLast(Character.valueOf(c));
            } else if (c == '|') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(' && ((Character)groups.peekLast()).charValue() != '|') {
                    return SkriptParser.error("Cannot use the pipe character '|' outside of groups. Escape it if you want to match a literal pipe: '\\|'");
                }
                groups.removeLast();
                groups.addLast(Character.valueOf(c));
            } else if (c == ')') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(' && ((Character)groups.peekLast()).charValue() != '|') {
                    return SkriptParser.error("Unexpected closing group bracket ')'. Escape it if you want to match a literal bracket: '\\)'");
                }
                if (((Character)groups.peekLast()).charValue() == '(') {
                    return SkriptParser.error("(...|...) groups have to contain at least one pipe character '|' to separate it into parts. Escape the brackets if you want to match literal brackets: \"\\(not a group\\)\"");
                }
                --groupLevel;
                groups.removeLast();
            } else if (c == '[') {
                ++optionalLevel;
                groups.addLast(Character.valueOf(c));
            } else if (c == ']') {
                if (optionalLevel == 0 || ((Character)groups.peekLast()).charValue() != '[') {
                    return SkriptParser.error("Unexpected closing optional bracket ']'. Escape it if you want to match a literal bracket: '\\]'");
                }
                --optionalLevel;
                groups.removeLast();
            } else if (c == '<') {
                j = pattern.indexOf(62, i + 1);
                if (j == -1) {
                    return SkriptParser.error("Missing closing regex bracket '>'. Escape the '<' if you want to match a literal bracket: '\\<'");
                }
                try {
                    Pattern.compile(pattern.substring(i + 1, j));
                }
                catch (PatternSyntaxException e) {
                    return SkriptParser.error("Invalid Regular Expression '" + pattern.substring(i + 1, j) + "': " + e.getLocalizedMessage());
                }
                i = j;
            } else {
                if (c == '>') {
                    return SkriptParser.error("Unexpected closing regex bracket '>'. Escape it if you want to match a literal bracket: '\\>'");
                }
                if (c == '%') {
                    j = pattern.indexOf(37, i + 1);
                    if (j == -1) {
                        return SkriptParser.error("Missing end sign '%' of expression. Escape the percent sign to match a literal '%': '\\%'");
                    }
                    NonNullPair<String, Boolean> p = Utils.getEnglishPlural(pattern.substring(i + 1, j));
                    ClassInfo<?> ci = Classes.getClassInfoFromUserInput(p.getFirst());
                    if (ci == null) {
                        return SkriptParser.error("The type '" + p.getFirst() + "' could not be found. Please check your spelling or escape the percent signs if you want to match literal %s: \"\\%not an expression\\%\"");
                    }
                    ps.add(p.getSecond());
                    b.append(pattern.substring(last, i + 1));
                    b.append(Utils.toEnglishPlural(ci.getCodeName(), p.getSecond()));
                    last = j;
                    i = j;
                } else if (c == '\\') {
                    if (i == pattern.length() - 1) {
                        return SkriptParser.error("Pattern must not end in an unescaped backslash. Add another backslash to escape it, or remove it altogether.");
                    }
                    ++i;
                }
            }
            ++i;
        }
        b.append(pattern.substring(last));
        boolean[] plurals = new boolean[ps.size()];
        int i2 = 0;
        while (i2 < plurals.length) {
            plurals[i2] = (Boolean)ps.get(i2);
            ++i2;
        }
        return new NonNullPair<String, boolean[]>(b.toString(), plurals);
    }

    @Nullable
    private static NonNullPair<String, boolean[]> error(String error) {
        Skript.error("Invalid pattern: " + error);
        return null;
    }

    public static boolean validateLine(String line) {
        if (StringUtils.count(line, '\"') % 2 != 0) {
            Skript.error(m_quotes_error.toString());
            return false;
        }
        int i = 0;
        while (i < line.length()) {
            if (i == -1) {
                Skript.error(m_brackets_error.toString());
                return false;
            }
            i = SkriptParser.next(line, i, ParseContext.DEFAULT);
        }
        return true;
    }

    private static ExprInfo getExprInfo(String s) throws MalformedPatternException, IllegalArgumentException, SkriptAPIException {
        ExprInfo r = exprInfoCache.get(s);
        if (r == null) {
            r = SkriptParser.createExprInfo(s);
            exprInfoCache.put(s, r);
        }
        return r;
    }

    private static ExprInfo createExprInfo(String s) throws MalformedPatternException, IllegalArgumentException, SkriptAPIException {
        int a;
        ExprInfo r = new ExprInfo(StringUtils.count(s, '/') + 1);
        r.isOptional = s.startsWith("-");
        if (r.isOptional) {
            s = s.substring(1);
        }
        if (s.startsWith("*")) {
            s = s.substring(1);
            r.flagMask &= 0xFFFFFFFE;
        } else if (s.startsWith("~")) {
            s = s.substring(1);
            r.flagMask &= 0xFFFFFFFD;
        }
        if (!r.isOptional) {
            r.isOptional = s.startsWith("-");
            if (r.isOptional) {
                s = s.substring(1);
            }
        }
        if ((a = s.indexOf("@")) != -1) {
            r.time = Integer.parseInt(s.substring(a + 1));
            s = s.substring(0, a);
        }
        String[] classes = s.split("/");
        assert (classes.length == r.classes.length);
        int i = 0;
        while (i < classes.length) {
            NonNullPair<String, Boolean> p = Utils.getEnglishPlural(classes[i]);
            r.classes[i] = Classes.getClassInfo(p.getFirst());
            r.isPlural[i] = p.getSecond();
            ++i;
        }
        return r;
    }

    private static final class ExprInfo {
        final ClassInfo<?>[] classes;
        final boolean[] isPlural;
        boolean isOptional;
        int flagMask = -1;
        int time = 0;

        public ExprInfo(int length) {
            this.classes = new ClassInfo[length];
            this.isPlural = new boolean[length];
        }
    }

    private static final class MalformedPatternException
    extends RuntimeException {
        private static final long serialVersionUID = -5133477361763823946L;

        public MalformedPatternException(String pattern, String message) {
            this(pattern, message, null);
        }

        public MalformedPatternException(String pattern, String message, @Nullable Throwable cause) {
            super(String.valueOf(message) + " [pattern: " + pattern + "]", cause);
        }
    }

    public static final class ParseResult {
        public final Expression<?>[] exprs;
        public final List<MatchResult> regexes = new ArrayList<MatchResult>(1);
        public final String expr;
        public int mark = 0;

        public ParseResult(SkriptParser parser, String pattern) {
            this.expr = parser.expr;
            this.exprs = new Expression[SkriptParser.countUnescaped(pattern, '%') / 2];
        }
    }
}

