/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Arithmetic")
@Description(value={"Arithmetic expressions for vectors."})
@Examples(value={"set {_v} to vector 1, 2, 3 // 5", "set {_v} to {_v} ++ {_v}", "set {_v} to {_v} ++ 5", "set {_v} to {_v} -- {_v}", "set {_v} to {_v} -- 5", "set {_v} to {_v} ** {_v}", "set {_v} to {_v} ** 5", "set {_v} to {_v} // {_v}", "set {_v} to {_v} // 5"})
@Since(value="2.2-dev28")
public class ExprVectorArithmetic
extends SimpleExpression<Vector> {
    private static final Patterns<Operator> patterns = new Patterns(new Object[][]{{"%vector%[ ]++[ ]%vector%", Operator.PLUS}, {"%vector%[ ]--[ ]%vector%", Operator.MINUS}, {"%vector%[ ]**[ ]%vector%", Operator.MULT}, {"%vector%[ ]//[ ]%vector%", Operator.DIV}});
    private Expression<Vector> first;
    private Expression<Vector> second;
    private Operator op;

    static {
        Skript.registerExpression(ExprVectorArithmetic.class, Vector.class, ExpressionType.SIMPLE, patterns.getPatterns());
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.first = exprs[0];
        this.second = exprs[1];
        this.op = patterns.getInfo(matchedPattern);
        return true;
    }

    protected Vector[] get(Event e) {
        Vector v1 = this.first.getSingle(e);
        Vector v2 = this.second.getSingle(e);
        if (v1 == null) {
            v1 = new Vector();
        }
        if (v2 == null) {
            v2 = new Vector();
        }
        return CollectionUtils.array(this.op.calculate(v1, v2));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.first.toString(e, debug)) + " " + (Object)((Object)this.op) + " " + this.second.toString(e, debug);
    }

    private static enum Operator {
        PLUS("++"){

            @Override
            public Vector calculate(Vector v1, Vector v2) {
                return v1.clone().add(v2);
            }
        }
        ,
        MINUS("--"){

            @Override
            public Vector calculate(Vector v1, Vector v2) {
                return v1.clone().subtract(v2);
            }
        }
        ,
        MULT("**"){

            @Override
            public Vector calculate(Vector v1, Vector v2) {
                return v1.clone().multiply(v2);
            }
        }
        ,
        DIV("//"){

            @Override
            public Vector calculate(Vector v1, Vector v2) {
                return v1.clone().divide(v2);
            }
        };

        public final String sign;

        private Operator(String sign) {
            this.sign = sign;
        }

        public abstract Vector calculate(Vector var1, Vector var2);

        public String toString() {
            return this.sign;
        }
    }
}

