/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.slot.Slot;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Max Durability")
@Description(value={"The maximum durability of an item."})
@Examples(value={"maximum durability of diamond sword", "if max durability of player's tool is not 0: # Item is damageable"})
@Since(value="2.5")
public class ExprMaxDurability
extends SimplePropertyExpression<Object, Number> {
    static {
        ExprMaxDurability.register(ExprMaxDurability.class, Number.class, "max[imum] durabilit(y|ies)", "itemstacks/slots");
    }

    @Override
    @Nullable
    public Number convert(Object o) {
        if (o instanceof Slot) {
            ItemStack i = ((Slot)o).getItem();
            return i == null ? null : Short.valueOf(i.getType().getMaxDurability());
        }
        return ((ItemStack)o).getType().getMaxDurability();
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    protected String getPropertyName() {
        return "max durability";
    }
}

