/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Item Amount")
@Description(value={"The amount of an <a href='classes.html#itemstack'>item stack</a>."})
@Examples(value={"send \"You have got %item amount of player's tool% %player's tool% in your hand!\" to player"})
@Since(value="2.2-dev24")
public class ExprItemAmount
extends SimplePropertyExpression<ItemType, Number> {
    static {
        ExprItemAmount.register(ExprItemAmount.class, Number.class, "item[[ ]stack] (amount|size|number)", "itemtypes");
    }

    @Override
    public Class<Number> getReturnType() {
        return Number.class;
    }

    @Override
    protected String getPropertyName() {
        return "item[[ ]stack] (amount|size|number)";
    }

    @Override
    public Number convert(ItemType item) {
        return item.getAmount();
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return mode != Changer.ChangeMode.REMOVE_ALL ? CollectionUtils.array(Number.class) : null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int amount = delta != null ? ((Number)delta[0]).intValue() : 0;
        switch (mode) {
            case ADD: {
                ItemType[] itemTypeArray = (ItemType[])this.getExpr().getArray(event);
                int n = itemTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemType item = itemTypeArray[n2];
                    item.setAmount(item.getAmount() + amount);
                    ++n2;
                }
                break;
            }
            case SET: {
                ItemType[] itemTypeArray = (ItemType[])this.getExpr().getArray(event);
                int n = itemTypeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ItemType item = itemTypeArray[n3];
                    item.setAmount(amount);
                    ++n3;
                }
                break;
            }
            case REMOVE: {
                ItemType[] itemTypeArray = (ItemType[])this.getExpr().getArray(event);
                int n = itemTypeArray.length;
                int n4 = 0;
                while (n4 < n) {
                    ItemType item = itemTypeArray[n4];
                    item.setAmount(item.getAmount() - amount);
                    ++n4;
                }
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                ItemType[] itemTypeArray = (ItemType[])this.getExpr().getArray(event);
                int n = itemTypeArray.length;
                int n5 = 0;
                while (n5 < n) {
                    ItemType item = itemTypeArray[n5];
                    item.setAmount(1);
                    ++n5;
                }
                break;
            }
        }
    }
}

