/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Index Of")
@Description(value={"The first or last index of a character (or text) in a text, or -1 if it doesn't occur in the text. Indices range from 1 to the <a href='#ExprIndexOf'>length</a> of the text."})
@Examples(value={"set {_first} to the first index of \"@\" in the text argument", "if {_s} contains \"abc\":", "\tset {_s} to the first (index of \"abc\" in {_s} + 3) characters of {_s} # removes everything after the first \"abc\" from {_s}"})
@Since(value="2.1")
public class ExprIndexOf
extends SimpleExpression<Integer> {
    boolean first;
    Expression<String> haystack;
    Expression<String> needle;

    static {
        Skript.registerExpression(ExprIndexOf.class, Integer.class, ExpressionType.COMBINED, "[the] (0\u00a6|0\u00a6first|1\u00a6last) index of %string% in %string%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.first = parseResult.mark == 0;
        this.needle = exprs[0];
        this.haystack = exprs[1];
        return true;
    }

    @Nullable
    protected Integer[] get(Event e) {
        String h = this.haystack.getSingle(e);
        String n = this.needle.getSingle(e);
        if (h == null || n == null) {
            return new Integer[0];
        }
        int i = this.first ? h.indexOf(n) : h.lastIndexOf(n);
        return new Integer[]{i == -1 ? -1 : i + 1};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the " + (this.first ? "first" : "last") + " index of " + this.needle.toString(e, debug) + " in " + this.haystack.toString(e, debug);
    }
}

