/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Color;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.FireworkEffect;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@NoDoc
public class ExprFireworkEffect
extends SimpleExpression<FireworkEffect> {
    private Expression<FireworkEffect.Type> type;
    private Expression<Color> color;
    private Expression<Color> fade;
    private boolean flicker;
    private boolean trail;
    private boolean hasFade;

    static {
        Skript.registerExpression(ExprFireworkEffect.class, FireworkEffect.class, ExpressionType.COMBINED, "(1\u00a6|2\u00a6flickering|3\u00a6trailing|4\u00a6flickering trailing|5\u00a6trailing flickering) %fireworktype% [firework [effect]] colo[u]red %colors%", "(1\u00a6|2\u00a6flickering|3\u00a6trailing|4\u00a6flickering trailing|5\u00a6trailing flickering) %fireworktype% [firework [effect]] colo[u]red %colors% fad(e|ing) [to] %colors%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.flicker = parseResult.mark == 2 || parseResult.mark > 3;
        this.trail = parseResult.mark >= 3;
        this.hasFade = matchedPattern == 1;
        this.type = exprs[0];
        this.color = exprs[1];
        if (this.hasFade) {
            this.fade = exprs[2];
        }
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends FireworkEffect> getReturnType() {
        return FireworkEffect.class;
    }

    @Nullable
    protected FireworkEffect[] get(Event e) {
        Color colour;
        FireworkEffect.Type type = this.type.getSingle(e);
        if (type == null) {
            return null;
        }
        FireworkEffect.Builder builder = FireworkEffect.builder().with(type);
        Color[] colorArray = this.color.getArray(e);
        int n = colorArray.length;
        int n2 = 0;
        while (n2 < n) {
            colour = colorArray[n2];
            builder.withColor(colour.asBukkitColor());
            ++n2;
        }
        if (this.hasFade) {
            colorArray = this.fade.getArray(e);
            n = colorArray.length;
            n2 = 0;
            while (n2 < n) {
                colour = colorArray[n2];
                builder.withFade(colour.asBukkitColor());
                ++n2;
            }
        }
        builder.flicker(this.flicker);
        builder.trail(this.trail);
        return CollectionUtils.array(builder.build());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "Firework effect " + this.type.toString(e, debug) + " with color " + this.color.toString(e, debug);
    }
}

