/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Custom Model Data")
@Description(value={"Get/set the CustomModelData tag for an item. (Value is an integer between 0 and 99999999)"})
@Examples(value={"set custom model data of player's tool to 3", "set {_model} to custom model data of player's tool"})
@RequiredPlugins(value={"1.14+"})
@Since(value="2.5")
public class ExprCustomModelData
extends SimplePropertyExpression<ItemType, Long> {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !ExprCustomModelData.class.desiredAssertionStatus();
        if (Skript.methodExists(ItemMeta.class, "hasCustomModelData", new Class[0])) {
            ExprCustomModelData.register(ExprCustomModelData.class, Long.class, "[custom] model data", "itemtypes");
        }
    }

    @Override
    public Long convert(ItemType item) {
        ItemMeta meta = item.getItemMeta();
        if (!$assertionsDisabled && meta == null) {
            throw new AssertionError();
        }
        if (meta.hasCustomModelData()) {
            return meta.getCustomModelData();
        }
        return 0L;
    }

    @Override
    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return CollectionUtils.array(Number.class);
    }

    @Override
    protected String getPropertyName() {
        return "custom model data";
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        long data = delta == null ? 0 : ((Number)delta[0]).intValue();
        if (data > 99999999L || data < 0L) {
            data = 0L;
        }
        ItemType[] itemTypeArray = (ItemType[])this.getExpr().getArray(e);
        int n = itemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType item = itemTypeArray[n2];
            long oldData = 0L;
            ItemMeta meta = item.getItemMeta();
            if (meta.hasCustomModelData()) {
                oldData = meta.getCustomModelData();
            }
            switch (mode) {
                case ADD: {
                    data = oldData + data;
                    break;
                }
                case REMOVE: {
                    data = oldData - data;
                    break;
                }
                case REMOVE_ALL: 
                case DELETE: 
                case RESET: {
                    data = 0L;
                }
            }
            meta.setCustomModelData(Integer.valueOf((int)data));
            item.setItemMeta(meta);
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean d) {
        return "custom model data of " + this.getExpr().toString(e, d);
    }
}

