/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Map;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Amount")
@Description(value={"The amount of something.", "Please note that <code>amount of %items%</code> will not return the number of items, but the number of stacks, e.g. 1 for a stack of 64 torches. To get the amount of items in a stack, see the <a href='#ExprItemAmount'>item amount</a> expression.", "", "Also, you can get the recursive size of a list, which will return the recursive size of the list with sublists included, e.g.", "{list::*} Structure", "    \u251c\u2500\u2500\u2500\u2500 {list::1}: 1", "    \u251c\u2500\u2500\u2500\u2500 {list::2}: 2", "    \u2502         \u251c\u2500\u2500\u2500\u2500 {list::2::1}: 3", "    \u2502         \u2502           \u2514\u2500\u2500\u2500\u2500 {list::2::1::1}: 4", "    \u2502         \u2514\u2500\u2500\u2500\u2500 {list::2::2}: 5", "    \u2514\u2500\u2500\u2500\u2500 {list::3}: 6", "Where using %size of {list::*}% will only return 3 (the first layer of indices only), while %recursive size of {list::*}% will return 6 (the entire list)", "Please note that getting a list's recursive size can cause lag if the list is large, so only use this expression if you need to!"})
@Examples(value={"message \"There are %number of all players% players online!\""})
@Since(value="1.0")
public class ExprAmount
extends SimpleExpression<Integer> {
    private boolean recursive;
    private Expression<?> expr;

    static {
        Skript.registerExpression(ExprAmount.class, Integer.class, ExpressionType.PROPERTY, "(amount|number|size) of %objects%", "recursive (amount|number|size) of %objects%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.expr = exprs[0];
        if (this.expr instanceof Literal) {
            return false;
        }
        if (this.expr.isSingle()) {
            Skript.error("'" + this.expr.toString(null, false) + "' can only ever have one value at most, thus the 'amount of ...' expression is useless. Use '... exists' instead to find out whether the expression has a value.");
            return false;
        }
        boolean bl = this.recursive = matchedPattern == 1;
        if (this.recursive && !(this.expr instanceof Variable)) {
            Skript.error("Getting the recursive size of a list only applies to variables, thus the '" + this.expr.toString(null, false) + "' expression is useless.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.recursive ? "recursize size of " : "amount of ") + this.expr.toString(e, debug);
    }

    protected Integer[] get(Event e) {
        Object var;
        if (this.recursive && (var = ((Variable)this.expr).getRaw(e)) != null) {
            return new Integer[]{ExprAmount.getRecursiveSize((Map)var)};
        }
        return new Integer[]{this.expr.getArray(e).length};
    }

    private static int getRecursiveSize(Map<String, ?> map) {
        int count = 0;
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                count += ExprAmount.getRecursiveSize((Map)value);
                continue;
            }
            ++count;
        }
        return count;
    }
}

