/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.ExprColoured;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.util.Kleenean;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Message")
@Description(value={"Sends a message to the given player. Only styles written", "in given string or in <a href=expressions.html#ExprColoured>formatted expressions</a> will be parsed."})
@Examples(value={"message \"A wild %player% appeared!\"", "message \"This message is a distraction. Mwahaha!\"", "send \"Your kill streak is %{kill streak::%uuid of player%}%.\" to player", "if the targeted entity exists:", "\tmessage \"You're currently looking at a %type of the targeted entity%!\""})
@Since(value="1.0, 2.2-dev26 (advanced features)")
public class EffMessage
extends Effect {
    private Expression<? extends String>[] messages;
    private Expression<String> messageExpr;
    private Expression<CommandSender> recipients;

    static {
        Skript.registerEffect(EffMessage.class, "(message|send [message[s]]) %strings% [to %commandsenders%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        Expression[] expressionArray;
        if (exprs[0] instanceof ExpressionList) {
            expressionArray = ((ExpressionList)exprs[0]).getExpressions();
        } else {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = exprs[0];
        }
        this.messages = expressionArray;
        this.messageExpr = exprs[0];
        this.recipients = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Expression<? extends String>[] expressionArray = this.messages;
        int n = this.messages.length;
        int n2 = 0;
        while (n2 < n) {
            Expression<? extends String> message = expressionArray[n2];
            CommandSender[] commandSenderArray = this.recipients.getArray(e);
            int n3 = commandSenderArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string;
                int n5;
                int n6;
                String[] stringArray;
                CommandSender receiver = commandSenderArray[n4];
                if (receiver instanceof Player) {
                    if (message instanceof VariableString) {
                        ((Player)receiver).spigot().sendMessage(BungeeConverter.convert(((VariableString)message).getMessageComponents(e)));
                    } else if (message instanceof ExprColoured && ((ExprColoured)message).isUnsafeFormat()) {
                        stringArray = message.getArray(e);
                        n6 = stringArray.length;
                        n5 = 0;
                        while (n5 < n6) {
                            string = stringArray[n5];
                            assert (string != null);
                            ((Player)receiver).spigot().sendMessage(BungeeConverter.convert(ChatMessages.parse(string)));
                            ++n5;
                        }
                    } else {
                        stringArray = message.getArray(e);
                        n6 = stringArray.length;
                        n5 = 0;
                        while (n5 < n6) {
                            string = stringArray[n5];
                            assert (string != null);
                            assert (string != null);
                            receiver.sendMessage(string);
                            ++n5;
                        }
                    }
                } else {
                    stringArray = message.getArray(e);
                    n6 = stringArray.length;
                    n5 = 0;
                    while (n5 < n6) {
                        string = stringArray[n5];
                        assert (string != null);
                        receiver.sendMessage(string);
                        ++n5;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "send " + this.messageExpr.toString(e, debug) + " to " + this.recipients.toString(e, debug);
    }
}

