/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Broadcast")
@Description(value={"Broadcasts a message to the server. Only formatting options supported by console", "(i.e. colors) are supported. If you need to use advanced chat formatting, send the", "message to all players instead of broadcasting it."})
@Examples(value={"broadcast \"Welcome %player% to the server!\"", "broadcast \"Woah! It's a message!\""})
@Since(value="1.0")
public class EffBroadcast
extends Effect {
    private Expression<String> messages;
    @Nullable
    private Expression<World> worlds;

    static {
        Skript.registerEffect(EffBroadcast.class, "broadcast %strings% [(to|in) %-worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.messages = vars[0];
        this.worlds = vars[1];
        return true;
    }

    @Override
    public void execute(Event e) {
        String[] stringArray = this.messages.getArray(e);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            Expression<World> worlds = this.worlds;
            if (worlds == null) {
                for (Player player : PlayerUtils.getOnlinePlayers()) {
                    player.sendMessage(m);
                }
                Bukkit.getConsoleSender().sendMessage(m);
            } else {
                World[] worldArray = worlds.getArray(e);
                int n3 = worldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    World world = worldArray[n4];
                    for (Player p : world.getPlayers()) {
                        p.sendMessage(m);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Expression<World> worlds = this.worlds;
        return "broadcast " + this.messages.toString(e, debug) + (worlds == null ? "" : " to " + worlds.toString(e, debug));
    }
}

