/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.apache.commons.lang.StringUtils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Alphanumeric")
@Description(value={"Checks if the given string is alphanumeric."})
@Examples(value={"if the argument is not alphanumeric:", "\tsend \"Invalid name!\""})
@Since(value="2.4")
public class CondAlphanumeric
extends Condition {
    private Expression<String> strings;

    static {
        Skript.registerCondition(CondAlphanumeric.class, "%strings% (is|are) alphanumeric", "%strings% (isn't|is not|aren't|are not) alphanumeric");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.strings = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.isNegated() ^ this.strings.check(e, StringUtils::isAlphanumeric);
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.strings.toString(e, debug)) + " is" + (this.isNegated() ? "n't" : "") + " alphanumeric";
    }
}

