/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

public class ItemUtils {
    private static final boolean damageMeta = Skript.classExists("org.bukkit.inventory.meta.Damageable");
    @Nullable
    private static final Material bedItem;
    @Nullable
    private static final Material bedBlock;

    static {
        if (!damageMeta) {
            bedItem = Material.valueOf((String)"BED");
            bedBlock = Material.valueOf((String)"BED_BLOCK");
        } else {
            bedItem = null;
            bedBlock = null;
        }
    }

    private ItemUtils() {
    }

    public static int getDamage(ItemStack stack) {
        if (damageMeta) {
            ItemMeta meta = stack.getItemMeta();
            if (meta instanceof Damageable) {
                return ((Damageable)meta).getDamage();
            }
            return 0;
        }
        return stack.getDurability();
    }

    public static void setDamage(ItemStack stack, int damage) {
        if (damageMeta) {
            ItemMeta meta = stack.getItemMeta();
            if (meta instanceof Damageable) {
                ((Damageable)meta).setDamage(damage);
                stack.setItemMeta(meta);
            }
        } else {
            stack.setDurability((short)damage);
        }
    }

    @Nullable
    public static Material asBlock(Material type) {
        if (!damageMeta && type == bedItem) {
            return bedBlock;
        }
        if (type.isBlock()) {
            return type;
        }
        return null;
    }

    public static Material asItem(Material type) {
        if (!damageMeta && type == bedBlock) {
            assert (bedItem != null);
            return bedItem;
        }
        return type;
    }

    public static boolean itemStacksEqual(@Nullable ItemStack is1, @Nullable ItemStack is2) {
        if (is1 == null || is2 == null) {
            return is1 == is2;
        }
        return is1.getType() == is2.getType() && ItemUtils.getDamage(is1) == ItemUtils.getDamage(is2) && is1.getItemMeta().equals(is2.getItemMeta());
    }
}

