/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Ternary")
@Description(value={"A shorthand expression for returning something based on a condition."})
@Examples(value={"set {points} to 500 if {admin::%player's uuid%} is set else 100"})
@Since(value="2.2-dev36")
public class ExprTernary<T>
extends SimpleExpression<T> {
    private final ExprTernary<?> source;
    private final Class<T> superType;
    @Nullable
    private Expression<Object> ifTrue;
    @Nullable
    private Condition condition;
    @Nullable
    private Expression<Object> ifFalse;

    static {
        Skript.registerExpression(ExprTernary.class, Object.class, ExpressionType.COMBINED, "%objects% if <.+>[,] (otherwise|else) %objects%");
    }

    public ExprTernary() {
        this(null, Object.class);
    }

    private ExprTernary(ExprTernary<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.ifTrue = source.ifTrue;
            this.ifFalse = source.ifFalse;
            this.condition = source.condition;
        }
        this.superType = Utils.getSuperType(types);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.ifTrue = LiteralUtils.defendExpression(exprs[0]);
        this.ifFalse = LiteralUtils.defendExpression(exprs[1]);
        if (this.ifFalse instanceof ExprTernary || this.ifTrue instanceof ExprTernary) {
            Skript.error("Ternary operators may not be nested!");
            return false;
        }
        String cond = parseResult.regexes.get(0).group();
        this.condition = Condition.parse(cond, "Can't understand this condition: " + cond);
        return this.condition != null && LiteralUtils.canInitSafely(this.ifTrue, this.ifFalse);
    }

    @Override
    protected T[] get(Event e) {
        Object[] values = this.condition.check(e) ? this.ifTrue.getArray(e) : this.ifFalse.getArray(e);
        try {
            return Converters.convertStrictly(values, this.superType);
        }
        catch (ClassCastException e1) {
            return (Object[])Array.newInstance(this.superType, 0);
        }
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprTernary<R>(this, to);
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public boolean isSingle() {
        return this.ifTrue.isSingle() && this.ifFalse.isSingle();
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.ifTrue.toString(e, debug)) + " if " + this.condition + " otherwise " + this.ifFalse.toString(e, debug);
    }
}

