/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.BlockLineIterator;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ArrayIterator;
import ch.njol.util.coll.iterator.IteratorIterable;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Blocks")
@Description(value={"Blocks relative to other blocks or between other blocks. Can be used to get blocks relative to other blocks or for looping."})
@Examples(value={"loop blocks above the player:", "loop blocks between the block below the player and the targeted block:", "set the blocks below the player, the victim and the targeted block to air"})
@Since(value="1.0")
public class ExprBlocks
extends SimpleExpression<Block> {
    private Expression<?> from;
    @Nullable
    private Expression<Block> end;
    @Nullable
    private Expression<Direction> direction;

    static {
        Skript.registerExpression(ExprBlocks.class, Block.class, ExpressionType.COMBINED, "[(all [[of] the]|the)] blocks %direction% [%locations%]", "[(all [[of] the]|the)] blocks from %location% [on] %direction%", "[(all [[of] the]|the)] blocks from %block% to %block%", "[(all [[of] the]|the)] blocks (within|between) %block% and %block%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        switch (matchedPattern) {
            case 0: {
                this.direction = exprs[0];
                this.from = exprs[1];
                break;
            }
            case 1: {
                this.from = exprs[0];
                this.direction = exprs[1];
                break;
            }
            case 2: 
            case 3: {
                this.from = exprs[0];
                this.end = exprs[1];
                break;
            }
            default: {
                assert (false) : matchedPattern;
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected Block[] get(Event e) {
        Expression<Direction> direction = this.direction;
        if (direction != null && !this.from.isSingle()) {
            Location[] ls = (Location[])this.from.getArray(e);
            Direction d = direction.getSingle(e);
            if (ls.length == 0 || d == null) {
                return new Block[0];
            }
            Block[] bs = new Block[ls.length];
            int i = 0;
            while (i < ls.length) {
                bs[i] = d.getRelative(ls[i]).getBlock();
                ++i;
            }
            return bs;
        }
        ArrayList<Block> r = new ArrayList<Block>();
        Iterator<Block> iter = this.iterator(e);
        if (iter == null) {
            return new Block[0];
        }
        for (Block b : new IteratorIterable<Block>(iter)) {
            r.add(b);
        }
        return r.toArray(new Block[r.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Iterator<Block> iterator(Event e) {
        try {
            Expression<Direction> direction = this.direction;
            if (direction != null) {
                Vector vector;
                if (!this.from.isSingle()) {
                    return new ArrayIterator<Block>(this.get(e));
                }
                Object o = this.from.getSingle(e);
                if (o == null) {
                    return null;
                }
                Location l = o instanceof Location ? (Location)o : ((Block)o).getLocation().add(0.5, 0.5, 0.5);
                Direction d = direction.getSingle(e);
                if (d == null) {
                    return null;
                }
                if (l.getBlock() == null) {
                    return null;
                }
                if (o != l) {
                    vector = d.getDirection((Block)o);
                    return new BlockLineIterator(l, vector, (double)SkriptConfig.maxTargetBlockDistance.value().intValue());
                }
                vector = d.getDirection(l);
                return new BlockLineIterator(l, vector, (double)SkriptConfig.maxTargetBlockDistance.value().intValue());
            }
            Block b = (Block)this.from.getSingle(e);
            if (b == null) {
                return null;
            }
            assert (this.end != null);
            Block b2 = this.end.getSingle(e);
            if (b2 == null) return null;
            if (b2.getWorld() == b.getWorld()) return new BlockLineIterator(b, b2);
            return null;
        }
        catch (IllegalStateException ex) {
            if (!ex.getMessage().equals("Start block missed in BlockIterator")) throw ex;
            return null;
        }
    }

    @Override
    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Expression<Block> end = this.end;
        if (end != null) {
            return "blocks from " + this.from.toString(e, debug) + " to " + end.toString(e, debug);
        }
        Expression<Direction> direction = this.direction;
        assert (direction != null);
        return "block" + (this.isSingle() ? "" : "s") + " " + direction.toString(e, debug) + " " + this.from.toString(e, debug);
    }
}

