/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.VisualEffect;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Play Effect")
@Description(value={"Plays a <a href='classes.html#visualeffect'>visual effect</a> at a given location or on a given entity.", "Please note that some effects can only be played on entities, e.g. wolf hearts or the hurt effect, and that these are always visible to all players."})
@Examples(value={"play wolf hearts on the clicked wolf", "show mob spawner flames at the targeted block to the player"})
@Since(value="2.1")
public class EffVisualEffect
extends Effect {
    private Expression<VisualEffect> effects;
    private Expression<Direction> direction;
    private Expression<?> where;
    @Nullable
    private Expression<Player> players;
    @Nullable
    private Expression<Number> radius;
    @Nullable
    private Expression<Number> count;

    static {
        Skript.registerEffect(EffVisualEffect.class, "(play|show) %visualeffects% (on|%directions%) %entities/locations% [(to %-players%|in (radius|range) of %number%)]", "(play|show) %number% %visualeffects% (on|%directions%) %locations% [(to %-players%|in (radius|range) of %number%)]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        int base = 0;
        if (matchedPattern == 1) {
            this.count = exprs[0];
            base = 1;
        }
        this.effects = exprs[base];
        this.direction = exprs[base + 1];
        this.where = exprs[base + 2];
        if (exprs[base + 3] != null) {
            if (exprs[3].getReturnType() == Player.class) {
                this.players = exprs[base + 3];
            } else {
                this.radius = exprs[base + 3];
            }
        }
        if (this.effects instanceof Literal) {
            VisualEffect[] effs = this.effects.getAll(null);
            boolean hasLocationEffect = false;
            boolean hasEntityEffect = false;
            VisualEffect[] visualEffectArray = effs;
            int n = effs.length;
            int n2 = 0;
            while (n2 < n) {
                VisualEffect e = visualEffectArray[n2];
                if (e.isEntityEffect()) {
                    hasEntityEffect = true;
                } else {
                    hasLocationEffect = true;
                }
                ++n2;
            }
            if (!hasLocationEffect && this.players != null) {
                Skript.warning("Entity effects are visible to all players");
            }
            if (!hasLocationEffect && !this.direction.isDefault()) {
                Skript.warning("Entity effects are always played on an entity");
            }
            if (hasEntityEffect && !Entity.class.isAssignableFrom(this.where.getReturnType())) {
                Skript.warning("Entity effects can only be played on entities");
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        Integer cnt;
        VisualEffect[] effs = this.effects.getArray(e);
        Direction[] dirs = this.direction.getArray(e);
        ?[] os = this.where.getArray(e);
        Player[] ps = this.players != null ? this.players.getArray(e) : null;
        Integer rad = this.radius != null ? (Number)this.radius.getSingle(e) : (Number)32;
        Number number = cnt = this.count != null ? (Number)this.count.getSingle(e) : (Number)0;
        assert (rad != null);
        assert (cnt != null);
        Direction[] directionArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            Direction d = directionArray[n2];
            ?[] objArray = os;
            int n3 = os.length;
            int n4 = 0;
            while (n4 < n3) {
                VisualEffect eff;
                int n5;
                int n6;
                VisualEffect[] visualEffectArray;
                Object o = objArray[n4];
                if (o instanceof Entity) {
                    visualEffectArray = effs;
                    n6 = effs.length;
                    n5 = 0;
                    while (n5 < n6) {
                        eff = visualEffectArray[n5];
                        eff.play(ps, d.getRelative((Entity)o), (Entity)o, cnt, rad);
                        ++n5;
                    }
                } else if (o instanceof Location) {
                    visualEffectArray = effs;
                    n6 = effs.length;
                    n5 = 0;
                    while (n5 < n6) {
                        eff = visualEffectArray[n5];
                        if (!eff.isEntityEffect()) {
                            eff.play(ps, d.getRelative((Location)o), null, cnt, rad);
                        }
                        ++n5;
                    }
                } else assert (false);
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "play " + this.effects.toString(e, debug) + " " + this.direction.toString(e, debug) + " " + this.where.toString(e, debug) + (this.players != null ? " to " + this.players.toString(e, debug) : "");
    }
}

