/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="PvP")
@Description(value={"Set the PvP state for a given world."})
@Examples(value={"enable PvP #(current world only)", "disable PvP in all worlds"})
@Since(value="1.3.4")
public class EffPvP
extends Effect {
    private Expression<World> worlds;
    private boolean enable;

    static {
        Skript.registerEffect(EffPvP.class, "enable PvP [in %worlds%]", "disable PVP [in %worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.worlds = exprs[0];
        this.enable = matchedPattern == 0;
        return true;
    }

    @Override
    protected void execute(Event e) {
        World[] worldArray = this.worlds.getArray(e);
        int n = worldArray.length;
        int n2 = 0;
        while (n2 < n) {
            World w = worldArray[n2];
            w.setPVP(this.enable);
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.enable ? "enable" : "disable") + " PvP in " + this.worlds.toString(e, debug);
    }
}

