/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.util.Patterns;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Comparison")
@Description(value={"A very general condition, it simply compares two values. Usually you can only compare for equality (e.g. block is/isn't of &lt;type&gt;), but some values can also be compared using greater than/less than. In that case you can also test for whether an object is between two others.", "Note: This is the only element where not all patterns are shown. It has actually another two sets of similar patters, but with <code>(was|were)</code> or <code>will be</code> instead of <code>(is|are)</code> respectively, which check different <a href='expressions.html#ExprTimeState'>time states</a> of the first expression."})
@Examples(value={"the clicked block is a stone slab or a double stone slab", "time in the player's world is greater than 8:00", "the creature is not an enderman or an ender dragon"})
@Since(value="1.0")
public class CondCompare
extends Condition {
    private static final Patterns<Comparator.Relation> patterns = new Patterns(new Object[][]{{"(1\u00a6neither|) %objects% ((is|are)(|2\u00a6(n't| not|4\u00a6 neither)) ((greater|more|higher|bigger|larger) than|above)|\\>) %objects%", Comparator.Relation.GREATER}, {"(1\u00a6neither|) %objects% ((is|are)(|2\u00a6(n't| not|4\u00a6 neither)) (greater|more|higher|bigger|larger|above) [than] or (equal to|the same as)|\\>=) %objects%", Comparator.Relation.GREATER_OR_EQUAL}, {"(1\u00a6neither|) %objects% ((is|are)(|2\u00a6(n't| not|4\u00a6 neither)) ((less|smaller) than|below)|\\<) %objects%", Comparator.Relation.SMALLER}, {"(1\u00a6neither|) %objects% ((is|are)(|2\u00a6(n't| not|4\u00a6 neither)) (less|smaller|below) [than] or (equal to|the same as)|\\<=) %objects%", Comparator.Relation.SMALLER_OR_EQUAL}, {"(1\u00a6neither|) %objects% (2\u00a6)((is|are) (not|4\u00a6neither)|isn't|aren't|!=) [equal to] %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects% (is|are|=) [(equal to|the same as)] %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects% (is|are) between %objects% and %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects% (2\u00a6)(is not|are not|isn't|aren't) between %objects% and %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects@-1% (was|were)(|2\u00a6(n't| not|4\u00a6 neither)) ((greater|more|higher|bigger|larger) than|above) %objects%", Comparator.Relation.GREATER}, {"(1\u00a6neither|) %objects@-1% (was|were)(|2\u00a6(n't| not|4\u00a6 neither)) (greater|more|higher|bigger|larger|above) [than] or (equal to|the same as) %objects%", Comparator.Relation.GREATER_OR_EQUAL}, {"(1\u00a6neither|) %objects@-1% (was|were)(|2\u00a6(n't| not|4\u00a6 neither)) ((less|smaller) than|below) %objects%", Comparator.Relation.SMALLER}, {"(1\u00a6neither|) %objects@-1% (was|were)(|2\u00a6(n't| not|4\u00a6 neither)) (less|smaller|below) [than] or (equal to|the same as) %objects%", Comparator.Relation.SMALLER_OR_EQUAL}, {"(1\u00a6neither|) %objects@-1% (2\u00a6)((was|were) (not|4\u00a6neither)|wasn't|weren't) [equal to] %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects@-1% (was|were) [(equal to|the same as)] %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects@-1% (was|were) between %objects% and %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects@-1% (2\u00a6)(was not|were not|wasn't|weren't) between %objects% and %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects@1% (will be|2\u00a6(will (not|4\u00a6neither) be|won't be)) ((greater|more|higher|bigger|larger) than|above) %objects%", Comparator.Relation.GREATER}, {"(1\u00a6neither|) %objects@1% (will be|2\u00a6(will (not|4\u00a6neither) be|won't be)) (greater|more|higher|bigger|larger|above) [than] or (equal to|the same as) %objects%", Comparator.Relation.GREATER_OR_EQUAL}, {"(1\u00a6neither|) %objects@1% (will be|2\u00a6(will (not|4\u00a6neither) be|won't be)) ((less|smaller) than|below) %objects%", Comparator.Relation.SMALLER}, {"(1\u00a6neither|) %objects@1% (will be|2\u00a6(will (not|4\u00a6neither) be|won't be)) (less|smaller|below) [than] or (equal to|the same as) %objects%", Comparator.Relation.SMALLER_OR_EQUAL}, {"(1\u00a6neither|) %objects@1% (2\u00a6)((will (not|4\u00a6neither) be|won't be)|(isn't|aren't|is not|are not) (turning|changing) [in]to) [equal to] %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects@1% (will be [(equal to|the same as)]|(is|are) (turning|changing) [in]to) %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects@1% will be between %objects% and %objects%", Comparator.Relation.EQUAL}, {"(1\u00a6neither|) %objects@1% (2\u00a6)(will not be|won't be) between %objects% and %objects%", Comparator.Relation.EQUAL}});
    private Expression<?> first;
    private Expression<?> second;
    @Nullable
    private Expression<?> third;
    private Comparator.Relation relation;
    @Nullable
    private Comparator comp;

    static {
        Skript.registerCondition(CondCompare.class, patterns.getPatterns());
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.first = vars[0];
        this.second = vars[1];
        if (vars.length == 3) {
            this.third = vars[2];
        }
        this.relation = patterns.getInfo(matchedPattern);
        if ((parser.mark & 2) != 0) {
            this.setNegated(true);
        }
        if ((parser.mark & 1) != 0) {
            this.setNegated(!this.isNegated());
        }
        if ((parser.mark & 4) != 0) {
            if (this.second instanceof ExpressionList) {
                ((ExpressionList)this.second).invertAnd();
            }
            if (this.third instanceof ExpressionList) {
                ((ExpressionList)this.third).invertAnd();
            }
        }
        boolean b = this.init(parser.expr);
        Expression<?> third = this.third;
        if (!b) {
            if (third == null && this.first.getReturnType() == Object.class && this.second.getReturnType() == Object.class) {
                return false;
            }
            Skript.error("Can't compare " + CondCompare.f(this.first) + " with " + CondCompare.f(this.second) + (third == null ? "" : " and " + CondCompare.f(third)), ErrorQuality.NOT_AN_EXPRESSION);
            return false;
        }
        Comparator comp = this.comp;
        if (comp != null) {
            if (third == null) {
                if (!this.relation.isEqualOrInverse() && !comp.supportsOrdering()) {
                    Skript.error("Can't test " + CondCompare.f(this.first) + " for being '" + (Object)((Object)this.relation) + "' " + CondCompare.f(this.second), ErrorQuality.NOT_AN_EXPRESSION);
                    return false;
                }
            } else if (!comp.supportsOrdering()) {
                Skript.error("Can't test " + CondCompare.f(this.first) + " for being 'between' " + CondCompare.f(this.second) + " and " + CondCompare.f(third), ErrorQuality.NOT_AN_EXPRESSION);
                return false;
            }
        }
        return true;
    }

    public static String f(Expression<?> e) {
        if (e.getReturnType() == Object.class) {
            return e.toString(null, false);
        }
        return Classes.getSuperClassInfo(e.getReturnType()).getName().withIndefiniteArticle();
    }

    private boolean init(String expr) {
        Class<?> s;
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        Expression<Object> third = this.third;
        try {
            Expression e;
            if (this.first.getReturnType() == Object.class) {
                e = this.first.getConvertedExpression(Object.class);
                if (e == null) {
                    log.printErrors();
                    return false;
                }
                this.first = e;
            }
            if (this.second.getReturnType() == Object.class) {
                e = this.second.getConvertedExpression(Object.class);
                if (e == null) {
                    log.printErrors();
                    return false;
                }
                this.second = e;
            }
            if (third != null && third.getReturnType() == Object.class) {
                e = third.getConvertedExpression(Object.class);
                if (e == null) {
                    log.printErrors();
                    return false;
                }
                third = e;
                this.third = third;
            }
            log.printLog();
        }
        finally {
            log.stop();
        }
        Class<?> f = this.first.getReturnType();
        Class<?> clazz = s = third == null ? this.second.getReturnType() : Utils.getSuperType(this.second.getReturnType(), third.getReturnType());
        if (f == Object.class || s == Object.class) {
            return true;
        }
        this.comp = Comparators.getComparator(f, s);
        return this.comp != null;
    }

    @Override
    public boolean check(Event e) {
        Expression<?> third = this.third;
        return this.first.check(e, o1 -> this.second.check(e, o2 -> {
            if (third == null) {
                return this.relation.is(this.comp != null ? this.comp.compare(o1, o2) : Comparators.compare(o1, o2));
            }
            return third.check(e, o3 -> this.relation == Comparator.Relation.NOT_EQUAL ^ (Comparator.Relation.GREATER_OR_EQUAL.is(this.comp != null ? this.comp.compare(o1, o2) : Comparators.compare(o1, o2)) && Comparator.Relation.SMALLER_OR_EQUAL.is(this.comp != null ? this.comp.compare(o1, o3) : Comparators.compare(o1, o3))));
        }), this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Expression<?> third = this.third;
        String s = third == null ? String.valueOf(this.first.toString(e, debug)) + " is " + (this.isNegated() ? "not " : "") + (Object)((Object)this.relation) + " " + this.second.toString(e, debug) : String.valueOf(this.first.toString(e, debug)) + " is " + (this.isNegated() ? "not " : "") + "between " + this.second.toString(e, debug) + " and " + third.toString(e, debug);
        if (debug) {
            s = String.valueOf(s) + " (comparator: " + this.comp + ")";
        }
        return s;
    }
}

