/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="View Distance")
@Description(value={"The view distance of a player. Can be changed."})
@Examples(value={"set view distance of player to 10", "set {_view} to view distance of player", "reset view distance of all players", "add 2 to view distance of player"})
@RequiredPlugins(value={"Paper 1.9-1.13.2"})
@Since(value="2.4")
public class ExprPlayerViewDistance
extends PropertyExpression<Player, Number> {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !ExprPlayerViewDistance.class.desiredAssertionStatus();
        if (Skript.methodExists(Player.class, "getViewDistance", new Class[0]) && !Skript.isRunningMinecraft(1, 14)) {
            ExprPlayerViewDistance.register(ExprPlayerViewDistance.class, Number.class, "view distance[s]", "players");
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Number[] get(Event e, Player[] source) {
        return this.get(source, new Getter<Integer, Player>(){

            @Override
            public Integer get(Player arg) {
                return arg.getViewDistance();
            }
        });
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case SET: 
            case REMOVE: 
            case DELETE: 
            case RESET: {
                return CollectionUtils.array(Number.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        int distance = delta == null ? 0 : ((Number)delta[0]).intValue();
        switch (mode) {
            case SET: 
            case DELETE: {
                Player[] playerArray = (Player[])this.getExpr().getArray(e);
                int n = playerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Player player = playerArray[n2];
                    player.setViewDistance(distance);
                    ++n2;
                }
                break;
            }
            case ADD: {
                Player[] playerArray = (Player[])this.getExpr().getArray(e);
                int n = playerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Player player = playerArray[n3];
                    player.setViewDistance(player.getViewDistance() + distance);
                    ++n3;
                }
                break;
            }
            case REMOVE: {
                Player[] playerArray = (Player[])this.getExpr().getArray(e);
                int n = playerArray.length;
                int n4 = 0;
                while (n4 < n) {
                    Player player = playerArray[n4];
                    player.setViewDistance(player.getViewDistance() - distance);
                    ++n4;
                }
                break;
            }
            case RESET: {
                Player[] playerArray = (Player[])this.getExpr().getArray(e);
                int n = playerArray.length;
                int n5 = 0;
                while (n5 < n) {
                    Player player = playerArray[n5];
                    player.setViewDistance(Bukkit.getServer().getViewDistance());
                    ++n5;
                }
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the view distance of " + this.getExpr().toString(e, debug);
    }
}

