/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Language")
@Description(value={"Currently selected game language of a player. The value of the language is not defined properly.", "The vanilla Minecraft client will use lowercase language / country pairs separated by an underscore, but custom resource packs may use any format they wish."})
@Examples(value={"message player's current language"})
@Since(value="2.3")
public class ExprLanguage
extends SimplePropertyExpression<Player, String> {
    private static final boolean USE_DEPRECATED_METHOD = !Skript.methodExists(Player.class, "getLocale", new Class[0]);

    static {
        ExprLanguage.register(ExprLanguage.class, String.class, "[([currently] selected|current)] [game] (language|locale) [setting]", "players");
    }

    @Override
    @Nullable
    public String convert(Player p) {
        if (USE_DEPRECATED_METHOD) {
            return p.spigot().getLocale();
        }
        return p.getLocale();
    }

    @Override
    protected String getPropertyName() {
        return "language";
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }
}

