/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Fox;
import org.eclipse.jdt.annotation.Nullable;

public class FoxData
extends EntityData<Fox> {
    @Nullable
    private Fox.Type type = null;

    static {
        if (Skript.classExists("org.bukkit.entity.Fox")) {
            EntityData.register(FoxData.class, "fox", Fox.class, 1, "fox", "red fox", "snow fox");
        }
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 0) {
            this.type = Fox.Type.values()[matchedPattern - 1];
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Fox> c, @Nullable Fox fox) {
        if (fox != null) {
            this.type = fox.getFoxType();
        }
        return true;
    }

    @Override
    public void set(Fox entity) {
        if (this.type != null) {
            entity.setFoxType(this.type);
        }
    }

    @Override
    protected boolean match(Fox entity) {
        return this.type == entity.getFoxType();
    }

    @Override
    public Class<? extends Fox> getType() {
        return Fox.class;
    }

    @Override
    public EntityData getSuperType() {
        return new FoxData();
    }

    @Override
    protected int hashCode_i() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    @Override
    protected boolean equals_i(EntityData<?> data) {
        if (!(data instanceof FoxData)) {
            return false;
        }
        return this.type == ((FoxData)data).type;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> data) {
        if (!(data instanceof FoxData)) {
            return false;
        }
        return this.type == null || this.type == ((FoxData)data).type;
    }
}

