/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.EmptyStacktraceException;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.MessageComponent;
import ch.njol.skript.variables.Variables;
import ch.njol.util.StringUtils;
import ch.njol.util.Validate;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.help.GenericCommandHelpTopic;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.HelpTopicComparator;
import org.bukkit.help.IndexHelpTopic;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;

public class ScriptCommand
implements TabExecutor {
    public static final Message m_executable_by_players = new Message("commands.executable by players");
    public static final Message m_executable_by_console = new Message("commands.executable by console");
    final String name;
    private final String label;
    private final List<String> aliases;
    private List<String> activeAliases;
    private String permission;
    private final VariableString permissionMessage;
    private final String description;
    @Nullable
    private final Timespan cooldown;
    private final Expression<String> cooldownMessage;
    private final String cooldownBypass;
    @Nullable
    private final Expression<String> cooldownStorage;
    final String usage;
    final Trigger trigger;
    private final String pattern;
    private final List<Argument<?>> arguments;
    public static final int PLAYERS = 1;
    public static final int CONSOLE = 2;
    public static final int BOTH = 3;
    final int executableBy;
    private transient PluginCommand bukkitCommand;
    private Map<UUID, Date> lastUsageMap = new HashMap<UUID, Date>();
    @Nullable
    private transient Command overridden = null;
    private transient Map<String, Command> overriddenAliases = new HashMap<String, Command>();
    private transient Collection<HelpTopic> helps = new ArrayList<HelpTopic>();

    public ScriptCommand(File script, String name, String pattern, List<Argument<?>> arguments, String description, String usage, ArrayList<String> aliases, String permission, @Nullable VariableString permissionMessage, @Nullable Timespan cooldown, @Nullable VariableString cooldownMessage, String cooldownBypass, @Nullable VariableString cooldownStorage, int executableBy, List<TriggerItem> items) {
        Validate.notNull(name, pattern, arguments, description, usage, aliases, items);
        this.name = name;
        this.label = name.toLowerCase();
        this.permission = permission;
        if (permissionMessage == null) {
            VariableString defaultMsg = VariableString.newInstance(Language.get("commands.no permission message"));
            assert (defaultMsg != null);
            this.permissionMessage = defaultMsg;
        } else {
            this.permissionMessage = permissionMessage;
        }
        this.cooldown = cooldown;
        this.cooldownMessage = cooldownMessage == null ? new SimpleLiteral<String>(Language.get("commands.cooldown message"), false) : cooldownMessage;
        this.cooldownBypass = cooldownBypass;
        this.cooldownStorage = cooldownStorage;
        aliases.removeIf(this.label::equalsIgnoreCase);
        this.aliases = aliases;
        this.activeAliases = new ArrayList<String>(aliases);
        this.description = Utils.replaceEnglishChatStyles(description);
        this.usage = Utils.replaceEnglishChatStyles(usage);
        this.executableBy = executableBy;
        this.pattern = pattern;
        this.arguments = arguments;
        this.trigger = new Trigger(script, "command /" + name, new SimpleEvent(), items);
        this.bukkitCommand = this.setupBukkitCommand();
    }

    private PluginCommand setupBukkitCommand() {
        try {
            Constructor c = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            c.setAccessible(true);
            PluginCommand bukkitCommand = (PluginCommand)c.newInstance(new Object[]{this.name, Skript.getInstance()});
            bukkitCommand.setAliases(this.aliases);
            bukkitCommand.setDescription(this.description);
            bukkitCommand.setLabel(this.label);
            bukkitCommand.setPermission(this.permission);
            if (this.permissionMessage.isSimple()) {
                bukkitCommand.setPermissionMessage(this.permissionMessage.toString(null));
            }
            bukkitCommand.setUsage(this.usage);
            bukkitCommand.setExecutor((CommandExecutor)this);
            return bukkitCommand;
        }
        catch (Exception e) {
            Skript.outdatedError(e);
            throw new EmptyStacktraceException();
        }
    }

    public boolean onCommand(@Nullable CommandSender sender, @Nullable Command command, @Nullable String label, @Nullable String[] args) {
        if (sender == null || label == null || args == null) {
            return false;
        }
        this.execute(sender, label, StringUtils.join(args, " "));
        return true;
    }

    public boolean execute(final CommandSender sender, final String commandLabel, final String rest) {
        if (sender instanceof Player) {
            if ((this.executableBy & 1) == 0) {
                sender.sendMessage("" + m_executable_by_console);
                return false;
            }
        } else if ((this.executableBy & 2) == 0) {
            sender.sendMessage("" + m_executable_by_players);
            return false;
        }
        final ScriptCommandEvent event = new ScriptCommandEvent(this, sender);
        if (!this.permission.isEmpty() && !sender.hasPermission(this.permission)) {
            if (sender instanceof Player) {
                List<MessageComponent> components = this.permissionMessage.getMessageComponents(event);
                ((Player)sender).spigot().sendMessage(BungeeConverter.convert(components));
            } else {
                sender.sendMessage(this.permissionMessage.getSingle(event));
            }
            return false;
        }
        if (sender instanceof Player && this.cooldown != null) {
            Player player = (Player)sender;
            UUID uuid = player.getUniqueId();
            if (!this.cooldownBypass.isEmpty() && player.hasPermission(this.cooldownBypass)) {
                this.setLastUsage(uuid, event, null);
            } else if (this.getLastUsage(uuid, event) != null) {
                if (this.getRemainingMilliseconds(uuid, event) <= 0L) {
                    if (!SkriptConfig.keepLastUsageDates.value().booleanValue()) {
                        this.setLastUsage(uuid, event, null);
                    }
                } else {
                    String msg = this.cooldownMessage.getSingle(event);
                    if (msg != null) {
                        sender.sendMessage(msg);
                    }
                    return false;
                }
            }
        }
        if (Bukkit.isPrimaryThread()) {
            this.execute2(event, sender, commandLabel, rest);
            if (sender instanceof Player && !event.isCooldownCancelled()) {
                this.setLastUsage(((Player)sender).getUniqueId(), event, new Date());
            }
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    ScriptCommand.this.execute2(event, sender, commandLabel, rest);
                    if (sender instanceof Player && !event.isCooldownCancelled()) {
                        ScriptCommand.this.setLastUsage(((Player)sender).getUniqueId(), event, new Date());
                    }
                }
            });
        }
        return true;
    }

    boolean execute2(ScriptCommandEvent event, CommandSender sender, String commandLabel, String rest) {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            boolean ok = SkriptParser.parseArguments(rest, this, event);
            if (!ok) {
                LogEntry e = log.getError();
                if (e != null) {
                    sender.sendMessage(ChatColor.DARK_RED + e.getMessage());
                }
                sender.sendMessage(this.usage);
                log.clear();
                log.printLog();
                return false;
            }
            log.clear();
            log.printLog();
        }
        finally {
            log.stop();
        }
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("# /" + this.name + " " + rest);
        }
        long startTrigger = System.nanoTime();
        if (!this.trigger.execute(event)) {
            sender.sendMessage(Commands.m_internal_error.toString());
        }
        if (Skript.log(Verbosity.VERY_HIGH)) {
            Skript.info("# " + this.name + " took " + 1.0 * (double)(System.nanoTime() - startTrigger) / 1000000.0 + " milliseconds");
        }
        return true;
    }

    public void sendHelp(CommandSender sender) {
        if (!this.description.isEmpty()) {
            sender.sendMessage(this.description);
        }
        sender.sendMessage(ChatColor.GOLD + "Usage" + ChatColor.RESET + ": " + this.usage);
    }

    public List<Argument<?>> getArguments() {
        return this.arguments;
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SimpleCommandMap commandMap, Map<String, Command> knownCommands, @Nullable Set<String> aliases) {
        SimpleCommandMap simpleCommandMap = commandMap;
        synchronized (simpleCommandMap) {
            this.overriddenAliases.clear();
            this.overridden = knownCommands.put(this.label, (Command)this.bukkitCommand);
            if (aliases != null) {
                aliases.remove(this.label);
            }
            Iterator<String> as = this.activeAliases.iterator();
            while (as.hasNext()) {
                String lowerAlias = as.next().toLowerCase();
                if (knownCommands.containsKey(lowerAlias) && (aliases == null || !aliases.contains(lowerAlias))) {
                    as.remove();
                    continue;
                }
                this.overriddenAliases.put(lowerAlias, knownCommands.put(lowerAlias, (Command)this.bukkitCommand));
                if (aliases == null) continue;
                aliases.add(lowerAlias);
            }
            this.bukkitCommand.setAliases(this.activeAliases);
            commandMap.register("skript", (Command)this.bukkitCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(SimpleCommandMap commandMap, Map<String, Command> knownCommands, @Nullable Set<String> aliases) {
        SimpleCommandMap simpleCommandMap = commandMap;
        synchronized (simpleCommandMap) {
            knownCommands.remove(this.label);
            knownCommands.remove("skript:" + this.label);
            if (aliases != null) {
                aliases.removeAll(this.activeAliases);
            }
            for (String string : this.activeAliases) {
                knownCommands.remove(string);
                knownCommands.remove("skript:" + string);
            }
            this.activeAliases = new ArrayList<String>(this.aliases);
            this.bukkitCommand.unregister((CommandMap)commandMap);
            this.bukkitCommand.setAliases(this.aliases);
            if (this.overridden != null) {
                knownCommands.put(this.label, this.overridden);
                this.overridden = null;
            }
            for (Map.Entry entry : this.overriddenAliases.entrySet()) {
                if (entry.getValue() == null) continue;
                knownCommands.put((String)entry.getKey(), (Command)entry.getValue());
                if (aliases == null) continue;
                aliases.add((String)entry.getKey());
            }
            this.overriddenAliases.clear();
        }
    }

    public void registerHelp() {
        this.helps.clear();
        HelpMap help = Bukkit.getHelpMap();
        GenericCommandHelpTopic t = new GenericCommandHelpTopic((Command)this.bukkitCommand);
        help.addTopic((HelpTopic)t);
        this.helps.add((HelpTopic)t);
        HelpTopic aliases = help.getHelpTopic("Aliases");
        if (aliases instanceof IndexHelpTopic) {
            aliases.getFullText((CommandSender)Bukkit.getConsoleSender());
            try {
                Field topics = IndexHelpTopic.class.getDeclaredField("allTopics");
                topics.setAccessible(true);
                ArrayList<Commands.CommandAliasHelpTopic> as = new ArrayList<Commands.CommandAliasHelpTopic>((Collection)topics.get(aliases));
                for (String alias : this.activeAliases) {
                    Commands.CommandAliasHelpTopic at = new Commands.CommandAliasHelpTopic("/" + alias, "/" + this.getLabel(), help);
                    as.add(at);
                    this.helps.add(at);
                }
                Collections.sort(as, HelpTopicComparator.helpTopicComparatorInstance());
                topics.set(aliases, as);
            }
            catch (Exception e) {
                Skript.outdatedError(e);
            }
        }
    }

    public void unregisterHelp() {
        Bukkit.getHelpMap().getHelpTopics().removeAll(this.helps);
        HelpTopic aliases = Bukkit.getHelpMap().getHelpTopic("Aliases");
        if (aliases != null && aliases instanceof IndexHelpTopic) {
            try {
                Field topics = IndexHelpTopic.class.getDeclaredField("allTopics");
                topics.setAccessible(true);
                ArrayList as = new ArrayList((Collection)topics.get(aliases));
                as.removeAll(this.helps);
                topics.set(aliases, as);
            }
            catch (Exception e) {
                Skript.outdatedError(e);
            }
        }
        this.helps.clear();
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    @Nullable
    public Timespan getCooldown() {
        return this.cooldown;
    }

    @Nullable
    private String getStorageVariableName(Event event) {
        assert (this.cooldownStorage != null);
        String variableString = this.cooldownStorage.getSingle(event);
        if (variableString == null) {
            return null;
        }
        if (variableString.startsWith("{")) {
            variableString = variableString.substring(1);
        }
        if (variableString.endsWith("}")) {
            variableString = variableString.substring(0, variableString.length() - 1);
        }
        return variableString;
    }

    @Nullable
    public Date getLastUsage(UUID uuid, Event event) {
        if (this.cooldownStorage == null) {
            return this.lastUsageMap.get(uuid);
        }
        String name = this.getStorageVariableName(event);
        assert (name != null);
        return (Date)Variables.getVariable(name, null, false);
    }

    public void setLastUsage(UUID uuid, Event event, @Nullable Date date) {
        if (this.cooldownStorage != null) {
            String name = this.getStorageVariableName(event);
            assert (name != null);
            Variables.setVariable(name, date, null, false);
        } else if (date == null) {
            this.lastUsageMap.remove(uuid);
        } else {
            this.lastUsageMap.put(uuid, date);
        }
    }

    public long getRemainingMilliseconds(UUID uuid, Event event) {
        Date lastUsage = this.getLastUsage(uuid, event);
        if (lastUsage == null) {
            return 0L;
        }
        Timespan cooldown = this.cooldown;
        assert (cooldown != null);
        long remaining = cooldown.getMilliSeconds() - this.getElapsedMilliseconds(uuid, event);
        if (remaining < 0L) {
            remaining = 0L;
        }
        return remaining;
    }

    public void setRemainingMilliseconds(UUID uuid, Event event, long milliseconds) {
        Timespan cooldown = this.cooldown;
        assert (cooldown != null);
        long cooldownMs = cooldown.getMilliSeconds();
        if (milliseconds > cooldownMs) {
            throw new IllegalArgumentException("Remaining time may not be longer than the cooldown");
        }
        this.setElapsedMilliSeconds(uuid, event, cooldownMs - milliseconds);
    }

    public long getElapsedMilliseconds(UUID uuid, Event event) {
        Date lastUsage = this.getLastUsage(uuid, event);
        return lastUsage == null ? 0L : new Date().getTimestamp() - lastUsage.getTimestamp();
    }

    public void setElapsedMilliSeconds(UUID uuid, Event event, long milliseconds) {
        Date date = new Date();
        date.subtract(new Timespan(milliseconds));
        this.setLastUsage(uuid, event, date);
    }

    public String getCooldownBypass() {
        return this.cooldownBypass;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getActiveAliases() {
        return this.activeAliases;
    }

    public PluginCommand getBukkitCommand() {
        return this.bukkitCommand;
    }

    @Nullable
    public File getScript() {
        return this.trigger.getScript();
    }

    @Nullable
    public List<String> onTabComplete(@Nullable CommandSender sender, @Nullable Command command, @Nullable String alias, @Nullable String[] args) {
        assert (args != null);
        int argIndex = args.length - 1;
        if (argIndex >= this.arguments.size()) {
            return Collections.emptyList();
        }
        Argument<?> arg = this.arguments.get(argIndex);
        Class<?> argType = arg.getType();
        if (argType.equals(Player.class) || argType.equals(OfflinePlayer.class)) {
            return null;
        }
        return Collections.emptyList();
    }
}

