/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.slot;

import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.BlockInventoryHolder;
import ch.njol.skript.util.slot.SlotWithIndex;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.eclipse.jdt.annotation.Nullable;

public class InventorySlot
extends SlotWithIndex {
    private final Inventory invi;
    private final int index;

    public InventorySlot(Inventory invi, int index) {
        assert (invi != null);
        assert (index >= 0);
        this.invi = invi;
        this.index = index;
    }

    public Inventory getInventory() {
        return this.invi;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @Nullable
    public ItemStack getItem() {
        ItemStack item = this.invi.getItem(this.index);
        return item == null ? new ItemStack(Material.AIR, 1) : item.clone();
    }

    @Override
    public void setItem(@Nullable ItemStack item) {
        this.invi.setItem(this.index, item != null && item.getType() != Material.AIR ? item : null);
        if (this.invi instanceof PlayerInventory) {
            PlayerUtils.updateInventory((Player)this.invi.getHolder());
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        InventoryHolder holder = this.invi.getHolder();
        if (holder instanceof BlockState) {
            holder = new BlockInventoryHolder((BlockState)holder);
        }
        if (this.invi.getHolder() != null) {
            if (this.invi instanceof CraftingInventory) {
                return "crafting slot " + this.index + " of " + Classes.toString(holder);
            }
            return "inventory slot " + this.index + " of " + Classes.toString(holder);
        }
        return "inventory slot " + this.index + " of " + Classes.toString(this.invi);
    }
}

