/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Special Number")
@Description(value={"Special number values, namely NaN, Infinity and -Infinity"})
@Examples(value={"if {_number} is NaN value:"})
@Since(value="2.2-dev32d")
public class ExprSpecialNumber
extends SimpleExpression<Number> {
    private int value;

    static {
        Skript.registerExpression(ExprSpecialNumber.class, Number.class, ExpressionType.SIMPLE, "(0\u00a6NaN|1\u00a6[(2\u00a6-|2\u00a6minus)](infinity|\u221e)) value", "value of (0\u00a6NaN|1\u00a6[(2\u00a6-|2\u00a6minus)](infinity|\u221e))");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.value = parseResult.mark;
        return true;
    }

    protected Number[] get(Event e) {
        return new Number[]{this.value == 0 ? Double.NaN : (this.value == 1 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY)};
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.value == 0 ? "NaN value" : (this.value == 1 ? "infinity value" : "-infinity value");
    }
}

