/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Locale;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Stop Sound")
@Description(value={"Stops a sound from playing to the specified players. Both Minecraft sound names and <a href=\"https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Sound.html\">Spigot sound names</a> are supported. Resource pack sounds are supported too. The sound category is 'master' by default. A sound can't be stopped from a different category. ", "", "Please note that sound names can get changed in any Minecraft or Spigot version, or even removed from Minecraft itself."})
@Examples(value={"stop sound \"block.chest.open\" for the player", "stop playing sounds \"ambient.underwater.loop\" and \"ambient.underwater.loop.additions\" to the player"})
@Since(value="2.4")
@RequiredPlugins(value={"Minecraft 1.10.2+, Minecraft 1.11+ (sound categories)"})
public class EffStopSound
extends Effect {
    private static final boolean SOUND_CATEGORIES_EXIST = Skript.classExists("org.bukkit.SoundCategory");
    private Expression<String> sounds;
    @Nullable
    private Expression<SoundCategory> category;
    private Expression<Player> players;

    static {
        if (Skript.methodExists(Player.class, "stopSound", String.class)) {
            if (SOUND_CATEGORIES_EXIST) {
                Skript.registerEffect(EffStopSound.class, "stop sound[s] %strings% [(in|from) %-soundcategory%] [(from playing to|for) %players%]", "stop playing sound[s] %strings% [(in|from) %-soundcategory%] [(to|for) %players%]");
            } else {
                Skript.registerEffect(EffStopSound.class, "stop sound[s] %strings% [(in|from) %-soundcategory%] [(from playing to|for) %players%]", "stop playing sound[s] %strings% [(in|from) %-soundcategory%] [(to|for) %players%]");
            }
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sounds = exprs[0];
        if (SOUND_CATEGORIES_EXIST) {
            this.category = exprs[1];
            this.players = exprs[2];
        } else {
            this.players = exprs[1];
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        SoundCategory category = null;
        if (SOUND_CATEGORIES_EXIST) {
            category = SoundCategory.MASTER;
            if (this.category != null && (category = this.category.getSingle(e)) == null) {
                return;
            }
        }
        String[] stringArray = this.sounds.getArray(e);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player p;
            int n3;
            int n4;
            Player[] playerArray;
            String sound = stringArray[n2];
            Sound soundEnum = null;
            try {
                soundEnum = Sound.valueOf((String)sound.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (soundEnum == null) {
                if (SOUND_CATEGORIES_EXIST) {
                    playerArray = this.players.getArray(e);
                    n4 = playerArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        p = playerArray[n3];
                        p.stopSound(sound, category);
                        ++n3;
                    }
                } else {
                    playerArray = this.players.getArray(e);
                    n4 = playerArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        p = playerArray[n3];
                        p.stopSound(sound);
                        ++n3;
                    }
                }
            } else if (SOUND_CATEGORIES_EXIST) {
                playerArray = this.players.getArray(e);
                n4 = playerArray.length;
                n3 = 0;
                while (n3 < n4) {
                    p = playerArray[n3];
                    p.stopSound(soundEnum, category);
                    ++n3;
                }
            } else {
                playerArray = this.players.getArray(e);
                n4 = playerArray.length;
                n3 = 0;
                while (n3 < n4) {
                    p = playerArray[n3];
                    p.stopSound(soundEnum);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "stop sound " + this.sounds.toString(e, debug) + (this.category != null ? " in " + this.category.toString(e, debug) : "") + " from playing to " + this.players.toString(e, debug);
    }
}

