/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Metrics;
import ch.njol.skript.ScriptLoader;
import ch.njol.skript.ServerPlatform;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.SkriptCommand;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.SkriptUpdater;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.bukkitutil.BukkitUnsafe;
import ch.njol.skript.bukkitutil.BurgerHelper;
import ch.njol.skript.bukkitutil.Workarounds;
import ch.njol.skript.classes.data.BukkitClasses;
import ch.njol.skript.classes.data.BukkitEventValues;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.classes.data.DefaultConverters;
import ch.njol.skript.classes.data.DefaultFunctions;
import ch.njol.skript.classes.data.JavaClasses;
import ch.njol.skript.classes.data.SkriptClasses;
import ch.njol.skript.command.Commands;
import ch.njol.skript.doc.Documentation;
import ch.njol.skript.events.EvtSkript;
import ch.njol.skript.hooks.Hook;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.BukkitLoggerFilter;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorDescLogHandler;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.timings.SkriptTimings;
import ch.njol.skript.update.ReleaseManifest;
import ch.njol.skript.update.ReleaseStatus;
import ch.njol.skript.update.UpdateManifest;
import ch.njol.skript.util.EmptyStacktraceException;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import ch.njol.skript.util.chat.BungeeConverter;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Closeable;
import ch.njol.util.NullableChecker;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.CheckedIterator;
import ch.njol.util.coll.iterator.EnumerationIterable;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.eclipse.jdt.annotation.Nullable;

public final class Skript
extends JavaPlugin
implements Listener {
    @Nullable
    private static Skript instance = null;
    private static boolean disabled = false;
    @Nullable
    private SkriptUpdater updater;
    @Nullable
    private static Version version = null;
    public static final Message m_invalid_reload = new Message("skript.invalid reload");
    public static final Message m_finished_loading = new Message("skript.finished loading");
    private static Version minecraftVersion = new Version(666);
    private static ServerPlatform serverPlatform = ServerPlatform.BUKKIT_UNKNOWN;
    @Nullable
    static Metrics metrics;
    private static final Collection<Closeable> closeOnDisable;
    public static final String SCRIPTSFOLDER = "scripts";
    public static final double EPSILON = 1.0E-10;
    public static final double EPSILON_MULT = 1.00001;
    public static final int MAXBLOCKID = 255;
    public static final int MAXDATAVALUE = 65535;
    public static final Thread.UncaughtExceptionHandler UEH;
    private static boolean acceptRegistrations;
    private static final HashMap<String, SkriptAddon> addons;
    @Nullable
    private static SkriptAddon addon;
    private static final Collection<SyntaxElementInfo<? extends Condition>> conditions;
    private static final Collection<SyntaxElementInfo<? extends Effect>> effects;
    private static final Collection<SyntaxElementInfo<? extends Statement>> statements;
    private static final List<ExpressionInfo<?, ?>> expressions;
    private static final int[] expressionTypesStartIndices;
    private static final Collection<SkriptEventInfo<?>> events;
    private static final String EXCEPTION_PREFIX = "#!#! ";
    private static Map<String, PluginDescriptionFile> pluginPackages;
    private static boolean checkedPlugins;
    public static String SKRIPT_PREFIX;

    static {
        closeOnDisable = Collections.synchronizedCollection(new ArrayList());
        UEH = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(@Nullable Thread t, @Nullable Throwable e) {
                Skript.exception(e, "Exception in thread " + (t == null ? null : t.getName()));
            }
        };
        acceptRegistrations = true;
        addons = new HashMap();
        conditions = new ArrayList<SyntaxElementInfo<? extends Condition>>(50);
        effects = new ArrayList<SyntaxElementInfo<? extends Effect>>(50);
        statements = new ArrayList<SyntaxElementInfo<? extends Statement>>(100);
        expressions = new ArrayList(100);
        expressionTypesStartIndices = new int[ExpressionType.values().length];
        events = new ArrayList(50);
        pluginPackages = new HashMap<String, PluginDescriptionFile>();
        checkedPlugins = false;
        SKRIPT_PREFIX = ChatColor.GRAY + "[" + ChatColor.GOLD + "Skript" + ChatColor.GRAY + "]" + ChatColor.RESET + " ";
    }

    public static Skript getInstance() {
        Skript i = instance;
        if (i == null) {
            throw new IllegalStateException();
        }
        return i;
    }

    public Skript() throws IllegalStateException {
        if (instance != null) {
            throw new IllegalStateException("Cannot create multiple instances of Skript!");
        }
        instance = this;
    }

    public static Version getVersion() {
        Version v = version;
        if (v == null) {
            throw new IllegalStateException();
        }
        return v;
    }

    public static ServerPlatform getServerPlatform() {
        if (Skript.classExists("net.glowstone.GlowServer")) {
            return ServerPlatform.BUKKIT_GLOWSTONE;
        }
        if (Skript.classExists("co.aikar.timings.Timings")) {
            return ServerPlatform.BUKKIT_PAPER;
        }
        if (Skript.classExists("org.spigotmc.SpigotConfig")) {
            return ServerPlatform.BUKKIT_SPIGOT;
        }
        if (Skript.classExists("org.bukkit.craftbukkit.CraftServer") || Skript.classExists("org.bukkit.craftbukkit.Main")) {
            return ServerPlatform.BUKKIT_CRAFTBUKKIT;
        }
        return ServerPlatform.BUKKIT_UNKNOWN;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean checkServerPlatform() {
        String bukkitV = Bukkit.getBukkitVersion();
        Matcher m = Pattern.compile("\\d+\\.\\d+(\\.\\d+)?").matcher(bukkitV);
        if (!m.find()) {
            Skript.error("The Bukkit version '" + bukkitV + "' does not contain a version number which is required for Skript to enable or disable certain features. " + "Skript will still work, but you might get random errors if you use features that are not available in your version of Bukkit.");
            minecraftVersion = new Version(666, 0, 0);
        } else {
            minecraftVersion = new Version(m.group());
        }
        Skript.debug("Loading for Minecraft " + minecraftVersion);
        if (!Skript.isRunningMinecraft(1, 9)) {
            if (!Skript.isRunningMinecraft(1, 8)) {
                Skript.error("This version of Skript does not work with Minecraft " + minecraftVersion);
                Skript.error("You probably want Skript 2.2 or 2.1 (Google to find where to get them)");
                Skript.error("Note that those versions are, of course, completely unsupported!");
                return false;
            }
            Skript.warning("Using this version of Skript on 1.8 is highly discouraged.");
            Skript.warning("Some features have been disabled; use older Skript to restore them.");
            Skript.warning("Also, there are probably bugs. And since 1.8 is not supported, they will not be fixed");
        }
        serverPlatform = Skript.getServerPlatform();
        Skript.debug("Server platform: " + (Object)((Object)serverPlatform));
        if (Skript.serverPlatform.works) {
            if (Skript.serverPlatform.supported) return true;
            Skript.warning("This server platform (" + Skript.serverPlatform.name + ") is not supported by Skript.");
            Skript.warning("It will still probably work, but if it does not, you are on your own.");
            Skript.warning("Skript officially supports Paper and Spigot.");
            return true;
        }
        Skript.error("It seems that this server platform (" + Skript.serverPlatform.name + ") does not work with Skript.");
        if (SkriptConfig.allowUnsafePlatforms.value().booleanValue()) {
            Skript.error("However, you have chosen to ignore this. Skript will probably still not work.");
            return true;
        }
        Skript.error("To prevent potentially unsafe behaviour, Skript has been disabled.");
        Skript.error("You may re-enable it by adding a configuration option 'allow unsafe platforms: true'");
        Skript.error("Note that it is unlikely that Skript works correctly even if you do so.");
        Skript.error("A better idea would be to install Paper or Spigot in place of your current server.");
        return false;
    }

    public void onEnable() {
        block46: {
            if (disabled) {
                Skript.error(m_invalid_reload.toString());
                this.setEnabled(false);
                return;
            }
            this.handleJvmArguments();
            version = new Version(this.getDescription().getVersion());
            Language.loadDefault(Skript.getAddonInstance());
            Workarounds.init();
            try {
                this.updater = new SkriptUpdater();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, "Update checker could not be initialized.");
            }
            if (!this.getDataFolder().isDirectory()) {
                this.getDataFolder().mkdirs();
            }
            File scripts = new File(this.getDataFolder(), SCRIPTSFOLDER);
            File config = new File(this.getDataFolder(), "config.sk");
            File features = new File(this.getDataFolder(), "features.sk");
            if (!(scripts.isDirectory() && config.exists() && features.exists())) {
                ZipFile f = null;
                try {
                    boolean populateExamples = false;
                    if (!scripts.isDirectory()) {
                        if (!scripts.mkdirs()) {
                            throw new IOException("Could not create the directory " + scripts);
                        }
                        populateExamples = true;
                    }
                    f = new ZipFile(this.getFile());
                    for (ZipEntry zipEntry : new EnumerationIterable<ZipEntry>(f.entries())) {
                        if (zipEntry.isDirectory()) continue;
                        File saveTo = null;
                        if (zipEntry.getName().startsWith("scripts/") && populateExamples) {
                            String fileName = zipEntry.getName().substring(zipEntry.getName().lastIndexOf(47) + 1);
                            saveTo = new File(scripts, String.valueOf(fileName.startsWith("-") ? "" : "-") + fileName);
                        } else if (zipEntry.getName().equals("config.sk")) {
                            if (!config.exists()) {
                                saveTo = config;
                            }
                        } else if (zipEntry.getName().startsWith("features.sk") && !features.exists()) {
                            saveTo = features;
                        }
                        if (saveTo == null) continue;
                        try (InputStream in = f.getInputStream(zipEntry);){
                            assert (in != null);
                            FileUtils.save(in, saveTo);
                        }
                    }
                    Skript.info("Successfully generated the config and the example scripts.");
                }
                catch (ZipException populateExamples) {
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block46;
                }
                catch (IOException e) {
                    try {
                        Skript.error("Error generating the default files: " + ExceptionUtils.toString(e));
                        break block46;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (f != null) {
                            try {
                                f.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (f == null) break block46;
                try {
                    f.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        new JavaClasses();
        Throwable classLoadError = null;
        try {
            new SkriptClasses();
        }
        catch (Throwable e) {
            classLoadError = e;
        }
        SkriptConfig.load();
        if (this.updater != null) {
            ConsoleCommandSender console = Bukkit.getConsoleSender();
            assert (console != null);
            assert (this.updater != null);
            this.updater.updateCheck((CommandSender)console);
        }
        if (!Skript.checkServerPlatform()) {
            disabled = true;
            this.setEnabled(false);
            return;
        }
        BukkitUnsafe.initialize();
        Aliases.load();
        if (classLoadError != null) {
            Skript.exception(classLoadError, new String[0]);
            this.setEnabled(false);
            return;
        }
        PluginCommand skriptCommand = this.getCommand("skript");
        assert (skriptCommand != null);
        skriptCommand.setExecutor((CommandExecutor)new SkriptCommand());
        new BukkitClasses();
        new BukkitEventValues();
        new DefaultComparators();
        new DefaultConverters();
        new DefaultFunctions();
        ChatMessages.registerListeners();
        try {
            Skript.getAddonInstance().loadClasses("ch.njol.skript", "conditions", "effects", "events", "expressions", "entity");
        }
        catch (Exception exception) {
            Skript.exception((Throwable)exception, "Could not load required .class files: " + exception.getLocalizedMessage());
            this.setEnabled(false);
            return;
        }
        Language.setUseLocal(true);
        Commands.registerListeners();
        if (Skript.logNormal()) {
            Skript.info(" " + Language.get("skript.copyright"));
        }
        final long l = Skript.testing() ? ((World)Bukkit.getWorlds().get(0)).getFullTime() : 0L;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (!$assertionsDisabled && ((World)Bukkit.getWorlds().get(0)).getFullTime() != l) {
                    throw new AssertionError();
                }
                try {
                    Throwable throwable = null;
                    Object var2_5 = null;
                    try (JarFile jar = new JarFile(Skript.this.getFile());){
                        for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                            if (!e.getName().startsWith("ch/njol/skript/hooks/") || !e.getName().endsWith("Hook.class") || StringUtils.count(e.getName(), '/') > 5) continue;
                            String c = e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length());
                            try {
                                Class<?> hook = Class.forName(c, true, Skript.this.getClassLoader());
                                if (hook == null || !Hook.class.isAssignableFrom(hook) || hook.isInterface() || Hook.class == hook) continue;
                                hook.getDeclaredConstructor(new Class[0]).setAccessible(true);
                                hook.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (ClassNotFoundException ex) {
                                Skript.exception((Throwable)ex, "Cannot load class " + c);
                            }
                            catch (ExceptionInInitializerError err) {
                                Skript.exception(err.getCause(), "Class " + c + " generated an exception while loading");
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Skript.error("Error while loading plugin hooks" + (e.getLocalizedMessage() == null ? "" : ": " + e.getLocalizedMessage()));
                    Skript.exception((Throwable)e, new String[0]);
                }
                Language.setUseLocal(false);
                Skript.stopAcceptingRegistrations();
                Documentation.generate();
                if (Skript.logNormal()) {
                    Skript.info("Loading variables...");
                }
                long vls = System.currentTimeMillis();
                1 h = SkriptLogger.startLogHandler(new ErrorDescLogHandler(){

                    @Override
                    public LogHandler.LogResult log(LogEntry entry) {
                        super.log(entry);
                        if (entry.level.intValue() >= Level.SEVERE.intValue()) {
                            Skript.logEx(entry.message);
                            return LogHandler.LogResult.DO_NOT_LOG;
                        }
                        return LogHandler.LogResult.LOG;
                    }

                    @Override
                    protected void beforeErrors() {
                        Skript.logEx();
                        Skript.logEx("===!!!=== Skript variable load error ===!!!===");
                        Skript.logEx("Unable to load (all) variables:");
                    }

                    @Override
                    protected void afterErrors() {
                        Skript.logEx();
                        Skript.logEx("Skript will work properly, but old variables might not be available at all and new ones may or may not be saved until Skript is able to create a backup of the old file and/or is able to connect to the database (which requires a restart of Skript)!");
                        Skript.logEx();
                    }

                    @Override
                    protected void onStop() {
                        super.onStop();
                    }
                });
                CountingLogHandler c = SkriptLogger.startLogHandler(new CountingLogHandler(SkriptLogger.SEVERE));
                try {
                    if (!Variables.load() && c.getCount() == 0) {
                        Skript.error("(no information available)");
                    }
                }
                finally {
                    c.stop();
                    h.stop();
                }
                long vld = System.currentTimeMillis() - vls;
                if (Skript.logNormal()) {
                    Skript.info("Loaded " + Variables.numVariables() + " variables in " + (double)(vld / 100L) / 10.0 + " seconds");
                }
                ScriptLoader.loadScripts();
                Skript.info(m_finished_loading.toString());
                EvtSkript.onSkriptStart();
                Metrics metrics = new Metrics(Skript.this);
                metrics.addCustomChart(new Metrics.SimplePie("pluginLanguage"){

                    @Override
                    public String getValue() {
                        return Language.getName();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("effectCommands"){

                    @Override
                    public String getValue() {
                        return "" + SkriptConfig.enableEffectCommands.value();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("uuidsWithPlayers"){

                    @Override
                    public String getValue() {
                        return "" + SkriptConfig.usePlayerUUIDsInVariableNames.value();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("playerVariableFix"){

                    @Override
                    public String getValue() {
                        return "" + SkriptConfig.enablePlayerVariableFix.value();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("logVerbosity"){

                    @Override
                    public String getValue() {
                        return SkriptConfig.verbosity.value().name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("pluginPriority"){

                    @Override
                    public String getValue() {
                        return SkriptConfig.defaultEventPriority.value().name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("logPlayerCommands"){

                    @Override
                    public String getValue() {
                        return "" + SkriptConfig.logPlayerCommands.value();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("maxTargetDistance"){

                    @Override
                    public String getValue() {
                        return "" + SkriptConfig.maxTargetBlockDistance.value();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("softApiExceptions"){

                    @Override
                    public String getValue() {
                        return "" + SkriptConfig.apiSoftExceptions.value();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("timingsStatus"){

                    @Override
                    public String getValue() {
                        if (!Skript.classExists("co.aikar.timings.Timings")) {
                            return "unsupported";
                        }
                        return "" + SkriptConfig.enableTimings.value();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("parseLinks"){

                    @Override
                    public String getValue() {
                        return ChatMessages.linkParseMode.name().toLowerCase(Locale.ENGLISH);
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("colorResetCodes"){

                    @Override
                    public String getValue() {
                        return "" + SkriptConfig.colorResetCodes.value();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("functionsWithNulls"){

                    @Override
                    public String getValue() {
                        return "" + SkriptConfig.executeFunctionsWithMissingParams.value();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("buildFlavor"){

                    @Override
                    public String getValue() {
                        if (Skript.this.updater != null) {
                            return ((Skript)(this).Skript.this).updater.getCurrentRelease().flavor;
                        }
                        return "unknown";
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("updateCheckerEnabled"){

                    @Override
                    public String getValue() {
                        return "" + SkriptConfig.checkForNewVersion.value();
                    }
                });
                metrics.addCustomChart(new Metrics.SimplePie("releaseChannel"){

                    @Override
                    public String getValue() {
                        return SkriptConfig.releaseChannel.value();
                    }
                });
                Skript.metrics = metrics;
                final Filter f = new Filter(){

                    @Override
                    public boolean isLoggable(@Nullable LogRecord record) {
                        if (record == null) {
                            return false;
                        }
                        return record.getMessage() == null || !record.getMessage().toLowerCase(Locale.ENGLISH).startsWith("can't keep up!");
                    }
                };
                BukkitLoggerFilter.addFilter(f);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.this, new Runnable(){

                    @Override
                    public void run() {
                        BukkitLoggerFilter.removeFilter(f);
                    }
                }, 1L);
            }
        });
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(final PlayerJoinEvent e) {
                if (e.getPlayer().hasPermission("skript.admin")) {
                    new Task((Plugin)Skript.this, 0L){

                        @Override
                        public void run() {
                            Player p = e.getPlayer();
                            SkriptUpdater updater = Skript.this.getUpdater();
                            if (p == null || updater == null) {
                                return;
                            }
                            if (updater.getReleaseStatus() == ReleaseStatus.OUTDATED) {
                                UpdateManifest update = updater.getUpdateManifest();
                                if (!$assertionsDisabled && update == null) {
                                    throw new AssertionError();
                                }
                                Skript.info((CommandSender)p, SkriptUpdater.m_update_available.toString(update.id, Skript.getVersion()));
                                p.spigot().sendMessage(BungeeConverter.convert(ChatMessages.parseToArray("Download it at: <aqua><u><link:" + update.downloadUrl + ">" + update.downloadUrl)));
                            }
                        }
                    };
                }
            }
        }, (Plugin)this);
        SkriptTimings.setSkript(this);
    }

    private void handleJvmArguments() {
        Path folder = this.getDataFolder().toPath();
        String burgerEnabled = System.getProperty("skript.burger.enable");
        if (burgerEnabled != null) {
            String burgerInput;
            String version = System.getProperty("skript.burger.version");
            if (version == null) {
                String inputFile = System.getProperty("skript.burger.file");
                if (inputFile == null) {
                    Skript.exception("burger enabled but skript.burger.file not provided");
                    return;
                }
                try {
                    burgerInput = new String(Files.readAllBytes(Paths.get(inputFile, new String[0])), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    Skript.exception((Throwable)e, new String[0]);
                    return;
                }
            }
            try {
                Path data = folder.resolve("burger-" + version + ".json");
                if (!Files.exists(data, new LinkOption[0])) {
                    URL url = new URL("https://pokechu22.github.io/Burger/" + version + ".json");
                    Throwable throwable = null;
                    Object var8_12 = null;
                    try (InputStream is = url.openStream();){
                        Files.copy(is, data, new CopyOption[0]);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                burgerInput = new String(Files.readAllBytes(data), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                Skript.exception((Throwable)e, new String[0]);
                return;
            }
            try {
                BurgerHelper burger = new BurgerHelper(burgerInput);
                Map<String, Material> materials = burger.mapMaterials();
                Map<Integer, Material> ids = BurgerHelper.mapIds();
                Gson gson = new Gson();
                Files.write(folder.resolve("materials_mappings.json"), gson.toJson(materials).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
                Files.write(folder.resolve("id_mappings.json"), gson.toJson(ids).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
    }

    public static Version getMinecraftVersion() {
        return minecraftVersion;
    }

    public static boolean isRunningCraftBukkit() {
        return serverPlatform == ServerPlatform.BUKKIT_CRAFTBUKKIT;
    }

    public static boolean isRunningMinecraft(int major, int minor) {
        return minecraftVersion.compareTo(major, minor) >= 0;
    }

    public static boolean isRunningMinecraft(int major, int minor, int revision) {
        return minecraftVersion.compareTo(major, minor, revision) >= 0;
    }

    public static boolean isRunningMinecraft(Version v) {
        return minecraftVersion.compareTo(v) >= 0;
    }

    @Deprecated
    public static boolean supports(String className) {
        return Skript.classExists(className);
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean methodExists(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            c.getDeclaredMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean methodExists(Class<?> c, String methodName, Class<?>[] parameterTypes, Class<?> returnType) {
        try {
            Method m = c.getDeclaredMethod(methodName, parameterTypes);
            return m.getReturnType() == returnType;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean fieldExists(Class<?> c, String fieldName) {
        try {
            c.getDeclaredField(fieldName);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    @Nullable
    public static Metrics getMetrics() {
        return metrics;
    }

    static void disableScripts() {
        VariableString.variableNames.clear();
        SkriptEventHandler.removeAllTriggers();
        Commands.clearCommands();
        Functions.clearFunctions();
    }

    static void reload() {
        if (!ScriptLoader.loadAsync) {
            Skript.disableScripts();
        }
        Skript.reloadMainConfig();
        Skript.reloadAliases();
        ScriptLoader.loadScripts();
    }

    static void reloadScripts() {
        if (!ScriptLoader.loadAsync) {
            Skript.disableScripts();
        }
        ScriptLoader.loadScripts();
    }

    static void reloadMainConfig() {
        SkriptConfig.load();
    }

    static void reloadAliases() {
        Aliases.clear();
        Aliases.load();
    }

    public static void closeOnDisable(Closeable closeable) {
        closeOnDisable.add(closeable);
    }

    public void onDisable() {
        if (disabled) {
            return;
        }
        disabled = true;
        EvtSkript.onSkriptStop();
        Skript.disableScripts();
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        for (Closeable c : closeOnDisable) {
            try {
                c.close();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, "An error occurred while shutting down.", "This might or might not cause any issues.");
            }
        }
        Thread t = Skript.newThread(new Runnable(){

            @Override
            public void run() {
                block13: {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        Field modifiers = Field.class.getDeclaredField("modifiers");
                        modifiers.setAccessible(true);
                        try (JarFile jar = new JarFile(Skript.this.getFile());){
                            for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                                if (!e.getName().endsWith(".class")) continue;
                                try {
                                    Class<?> c = Class.forName(e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length()), false, Skript.this.getClassLoader());
                                    Field[] fieldArray = c.getDeclaredFields();
                                    int n = fieldArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Field f = fieldArray[n2];
                                        if (Modifier.isStatic(f.getModifiers()) && !f.getType().isPrimitive()) {
                                            if (Modifier.isFinal(f.getModifiers())) {
                                                modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                                            }
                                            f.setAccessible(true);
                                            f.set(null, null);
                                        }
                                        ++n2;
                                    }
                                }
                                catch (Throwable ex) {
                                    if (!Skript.testing()) continue;
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                    catch (Throwable ex) {
                        if (!Skript.testing()) break block13;
                        ex.printStackTrace();
                    }
                }
            }
        }, "Skript cleanup thread");
        t.setPriority(1);
        t.setDaemon(true);
        t.start();
    }

    public static void outdatedError() {
        Skript.error("Skript v" + Skript.getInstance().getDescription().getVersion() + " is not fully compatible with Bukkit " + Bukkit.getVersion() + ". Some feature(s) will be broken until you update Skript.");
    }

    public static void outdatedError(Exception e) {
        Skript.outdatedError();
        if (Skript.testing()) {
            e.printStackTrace();
        }
    }

    public static String toString(double n) {
        return StringUtils.toString(n, SkriptConfig.numberAccuracy.value());
    }

    public static Thread newThread(Runnable r, String name) {
        Thread t = new Thread(r, name);
        t.setUncaughtExceptionHandler(UEH);
        return t;
    }

    public static boolean isAcceptRegistrations() {
        return acceptRegistrations;
    }

    public static void checkAcceptRegistrations() {
        if (!acceptRegistrations) {
            throw new SkriptAPIException("Registering is disabled after initialisation!");
        }
    }

    private static void stopAcceptingRegistrations() {
        acceptRegistrations = false;
        Converters.createMissingConverters();
        Classes.onRegistrationsStop();
    }

    public static SkriptAddon registerAddon(JavaPlugin p) {
        Skript.checkAcceptRegistrations();
        if (addons.containsKey(p.getName())) {
            throw new IllegalArgumentException("The plugin " + p.getName() + " is already registered");
        }
        SkriptAddon addon = new SkriptAddon(p);
        addons.put(p.getName(), addon);
        return addon;
    }

    @Nullable
    public static SkriptAddon getAddon(JavaPlugin p) {
        return addons.get(p.getName());
    }

    @Nullable
    public static SkriptAddon getAddon(String name) {
        return addons.get(name);
    }

    public static Collection<SkriptAddon> getAddons() {
        return Collections.unmodifiableCollection(addons.values());
    }

    public static SkriptAddon getAddonInstance() {
        SkriptAddon a = addon;
        if (a == null) {
            addon = new SkriptAddon(Skript.getInstance()).setLanguageFileDirectory("lang");
            return addon;
        }
        return a;
    }

    public static <E extends Condition> void registerCondition(Class<E> condition, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, condition, originClassPath);
        conditions.add(info);
        statements.add(info);
    }

    public static <E extends Effect> void registerEffect(Class<E> effect, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, effect, originClassPath);
        effects.add(info);
        statements.add(info);
    }

    public static Collection<SyntaxElementInfo<? extends Statement>> getStatements() {
        return statements;
    }

    public static Collection<SyntaxElementInfo<? extends Condition>> getConditions() {
        return conditions;
    }

    public static Collection<SyntaxElementInfo<? extends Effect>> getEffects() {
        return effects;
    }

    public static <E extends Expression<T>, T> void registerExpression(Class<E> c, Class<T> returnType, ExpressionType type, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        if (returnType.isAnnotation() || returnType.isArray() || returnType.isPrimitive()) {
            throw new IllegalArgumentException("returnType must be a normal type");
        }
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        ExpressionInfo<E, T> info = new ExpressionInfo<E, T>(patterns, returnType, c, originClassPath);
        int i = type.ordinal() + 1;
        while (i < ExpressionType.values().length) {
            int n = i++;
            expressionTypesStartIndices[n] = expressionTypesStartIndices[n] + 1;
        }
        expressions.add(expressionTypesStartIndices[type.ordinal()], info);
    }

    public static Iterator<ExpressionInfo<?, ?>> getExpressions() {
        return expressions.iterator();
    }

    public static Iterator<ExpressionInfo<?, ?>> getExpressions(final Class<?> ... returnTypes) {
        return new CheckedIterator(Skript.getExpressions(), new NullableChecker<ExpressionInfo<?, ?>>(){

            @Override
            public boolean check(@Nullable ExpressionInfo<?, ?> i) {
                if (i == null || i.returnType == Object.class) {
                    return true;
                }
                Class[] classArray = returnTypes;
                int n = returnTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class returnType = classArray[n2];
                    if (!$assertionsDisabled && returnType == null) {
                        throw new AssertionError();
                    }
                    if (Converters.converterExists(i.returnType, returnType)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }

    public static <E extends SkriptEvent> SkriptEventInfo<E> registerEvent(String name, Class<E> c, Class<? extends Event> event, String ... patterns) {
        Skript.checkAcceptRegistrations();
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        assert (originClassPath != null);
        SkriptEventInfo<E> r = new SkriptEventInfo<E>(name, patterns, c, originClassPath, CollectionUtils.array(event));
        events.add(r);
        return r;
    }

    public static <E extends SkriptEvent> SkriptEventInfo<E> registerEvent(String name, Class<E> c, Class<? extends Event>[] events, String ... patterns) {
        Skript.checkAcceptRegistrations();
        String originClassPath = Thread.currentThread().getStackTrace()[2].getClassName();
        assert (originClassPath != null);
        SkriptEventInfo<E> r = new SkriptEventInfo<E>(name, patterns, c, originClassPath, events);
        Skript.events.add(r);
        return r;
    }

    public static Collection<SkriptEventInfo<?>> getEvents() {
        return events;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean dispatchCommand(CommandSender sender, String command) {
        try {
            if (sender instanceof Player) {
                PlayerCommandPreprocessEvent e = new PlayerCommandPreprocessEvent((Player)sender, "/" + command);
                Bukkit.getPluginManager().callEvent((Event)e);
                if (!e.isCancelled() && e.getMessage() != null && e.getMessage().startsWith("/")) {
                    return Bukkit.dispatchCommand((CommandSender)e.getPlayer(), (String)e.getMessage().substring(1));
                }
                return false;
            }
            ServerCommandEvent e = new ServerCommandEvent(sender, command);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.getCommand() != null && !e.getCommand().isEmpty()) {
                return Bukkit.dispatchCommand((CommandSender)e.getSender(), (String)e.getCommand());
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean logNormal() {
        return SkriptLogger.log(Verbosity.NORMAL);
    }

    public static boolean logHigh() {
        return SkriptLogger.log(Verbosity.HIGH);
    }

    public static boolean logVeryHigh() {
        return SkriptLogger.log(Verbosity.VERY_HIGH);
    }

    public static boolean debug() {
        return SkriptLogger.debug();
    }

    public static boolean testing() {
        return Skript.debug() || Skript.class.desiredAssertionStatus();
    }

    public static boolean log(Verbosity minVerb) {
        return SkriptLogger.log(minVerb);
    }

    public static void debug(String info) {
        if (!Skript.debug()) {
            return;
        }
        SkriptLogger.log(SkriptLogger.DEBUG, info);
    }

    public static void info(String info) {
        SkriptLogger.log(Level.INFO, info);
    }

    public static void warning(String warning) {
        SkriptLogger.log(Level.WARNING, warning);
    }

    public static void error(@Nullable String error) {
        if (error != null) {
            SkriptLogger.log(Level.SEVERE, error);
        }
    }

    public static void error(String error, ErrorQuality quality) {
        SkriptLogger.log(new LogEntry(SkriptLogger.SEVERE, quality, error));
    }

    public static EmptyStacktraceException exception(String ... info) {
        return Skript.exception(null, info);
    }

    public static EmptyStacktraceException exception(@Nullable Throwable cause, String ... info) {
        return Skript.exception(cause, null, null, info);
    }

    public static EmptyStacktraceException exception(@Nullable Throwable cause, @Nullable Thread thread, String ... info) {
        return Skript.exception(cause, thread, null, info);
    }

    public static EmptyStacktraceException exception(@Nullable Throwable cause, @Nullable TriggerItem item, String ... info) {
        return Skript.exception(cause, null, item, info);
    }

    public static EmptyStacktraceException exception(@Nullable Throwable cause, @Nullable Thread thread, @Nullable TriggerItem item, String ... info) {
        Object name2;
        if (!checkedPlugins) {
            Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
            int n = pluginArray.length;
            int n2 = 0;
            while (n2 < n) {
                PluginDescriptionFile desc;
                Plugin plugin = pluginArray[n2];
                if (!plugin.getName().equals("Skript") && ((desc = plugin.getDescription()).getDepend().contains("Skript") || desc.getSoftDepend().contains("Skript"))) {
                    String[] parts = desc.getMain().split("\\.");
                    name2 = new StringBuilder(desc.getMain().length());
                    int i = 0;
                    while (i < parts.length - 1) {
                        ((StringBuilder)name2).append(parts[i]).append('.');
                        ++i;
                    }
                    pluginPackages.put(((StringBuilder)name2).toString(), desc);
                    if (Skript.debug()) {
                        Skript.info("Identified potential addon: " + desc.getFullName() + " (" + ((StringBuilder)name2).toString() + ")");
                    }
                }
                ++n2;
            }
            checkedPlugins = true;
        }
        String issuesUrl = "https://github.com/SkriptLang/Skript/issues";
        Skript.logEx();
        Skript.logEx("[Skript] Severe Error:");
        Skript.logEx(info);
        Skript.logEx();
        Skript.logEx("Something went horribly wrong with Skript.");
        Skript.logEx("This issue is NOT your fault! You probably can't fix it yourself, either.");
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        HashSet<PluginDescriptionFile> stackPlugins = new HashSet<PluginDescriptionFile>();
        name2 = stackTrace;
        int parts = stackTrace.length;
        int desc = 0;
        while (desc < parts) {
            StackTraceElement s = name2[desc];
            for (Map.Entry<String, PluginDescriptionFile> e : pluginPackages.entrySet()) {
                if (!s.getClassName().contains(e.getKey())) continue;
                stackPlugins.add(e.getValue());
            }
            ++desc;
        }
        SkriptUpdater updater = Skript.getInstance().getUpdater();
        if (!Skript.isRunningMinecraft(1, 9)) {
            Skript.logEx("You are running an outdated Minecraft version not supported by Skript.");
            Skript.logEx("Please update to Minecraft 1.9.4 or later or fix this yourself and send us a pull request.");
            Skript.logEx("Alternatively, use an older Skript version; do note that those are also unsupported by us.");
            Skript.logEx("");
            Skript.logEx("Again, we do not support Minecraft versions this old.");
        } else if (!Skript.serverPlatform.supported) {
            Skript.logEx("Your server platform appears to be unsupported by Skript. It might not work reliably.");
            Skript.logEx("You can report this at " + issuesUrl + ". However, we may be unable to fix the issue.");
            Skript.logEx("It is recommended that you switch to Paper or Spigot, should you encounter problems.");
        } else if (updater != null && updater.getReleaseStatus() == ReleaseStatus.OUTDATED) {
            Skript.logEx("You're running outdated version of Skript! Please try updating it NOW; it might fix this.");
            Skript.logEx("Run /sk update check to get a download link to latest Skript!");
            Skript.logEx("You will be given instructions how to report this error if it persists after update.");
        } else if (pluginPackages.isEmpty()) {
            Skript.logEx("You should report it at " + issuesUrl + ". Please copy paste this report there (or use paste service).");
            Skript.logEx("This ensures that your issue is noticed and will be fixed as soon as possible.");
        } else {
            StringBuilder pluginsMessage;
            Skript.logEx("It looks like you are using some plugin(s) that alter how Skript works (addons).");
            if (stackPlugins.isEmpty()) {
                Skript.logEx("Here is full list of them:");
                pluginsMessage = new StringBuilder();
                for (PluginDescriptionFile desc2 : pluginPackages.values()) {
                    pluginsMessage.append(desc2.getName());
                    String website = desc2.getWebsite();
                    if (website != null && !website.isEmpty()) {
                        pluginsMessage.append(" (").append(desc2.getWebsite()).append(")");
                    }
                    pluginsMessage.append(" ");
                }
                Skript.logEx(pluginsMessage.toString());
                Skript.logEx("We could not identify which of those are specially related, so this might also be Skript issue.");
            } else {
                Skript.logEx("Following plugins are probably related to this error in some way:");
                pluginsMessage = new StringBuilder();
                for (PluginDescriptionFile desc3 : stackPlugins) {
                    pluginsMessage.append(desc3.getName());
                    String website = desc3.getWebsite();
                    if (website != null && !website.isEmpty()) {
                        pluginsMessage.append(" (").append(desc3.getWebsite()).append(")");
                    }
                    pluginsMessage.append(" ");
                }
                Skript.logEx(pluginsMessage.toString());
            }
            Skript.logEx("You should try disabling those plugins one by one, trying to find which one causes it.");
            Skript.logEx("If the error doesn't disappear even after disabling all listed plugins, it is probably Skript issue.");
            Skript.logEx("In that case, you will be given instruction on how should you report it.");
            Skript.logEx("On the other hand, if the error disappears when disabling some plugin, report it to author of that plugin.");
            Skript.logEx("Only if the author tells you to do so, report it to Skript's issue tracker.");
        }
        Skript.logEx();
        Skript.logEx("Stack trace:");
        if (cause == null || cause.getStackTrace().length == 0) {
            Skript.logEx("  warning: no/empty exception given, dumping current stack trace instead");
            cause = new Exception(cause);
        }
        boolean first = true;
        while (cause != null) {
            Skript.logEx(String.valueOf(first ? "" : "Caused by: ") + cause.toString());
            StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
            int n = stackTraceElementArray.length;
            int name2 = 0;
            while (name2 < n) {
                StackTraceElement e = stackTraceElementArray[name2];
                Skript.logEx("    at " + e.toString());
                ++name2;
            }
            cause = cause.getCause();
            first = false;
        }
        Skript.logEx();
        Skript.logEx("Version Information:");
        if (updater != null) {
            ReleaseStatus status = updater.getReleaseStatus();
            Skript.logEx("  Skript: " + Skript.getVersion() + (status == ReleaseStatus.LATEST ? " (latest)" : (status == ReleaseStatus.OUTDATED ? " (OUTDATED)" : (status == ReleaseStatus.CUSTOM ? " (custom version)" : ""))));
            ReleaseManifest current = updater.getCurrentRelease();
            Skript.logEx("    Flavor: " + current.flavor);
            Skript.logEx("    Date: " + current.date);
        } else {
            Skript.logEx("  Skript: " + Skript.getVersion() + " (unknown; likely custom)");
        }
        Skript.logEx("  Bukkit: " + Bukkit.getBukkitVersion());
        Skript.logEx("  Minecraft: " + Skript.getMinecraftVersion());
        Skript.logEx("  Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ")");
        Skript.logEx("  OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        Skript.logEx();
        Skript.logEx("Server platform: " + Skript.serverPlatform.name + (Skript.serverPlatform.supported ? "" : " (unsupported)"));
        Skript.logEx();
        Skript.logEx("Current node: " + SkriptLogger.getNode());
        Skript.logEx("Current item: " + (item == null ? "null" : item.toString(null, true)));
        if (item != null && item.getTrigger() != null) {
            Trigger trigger = item.getTrigger();
            assert (trigger != null);
            File script = trigger.getScript();
            Skript.logEx("Current trigger: " + trigger.toString(null, true) + " (" + (script == null ? "null" : script.getName()) + ", line " + trigger.getLineNumber() + ")");
        }
        Skript.logEx();
        Skript.logEx("Thread: " + (thread == null ? Thread.currentThread() : thread).getName());
        Skript.logEx();
        Skript.logEx("Language: " + Language.getName());
        Skript.logEx("Link parse mode: " + (Object)((Object)ChatMessages.linkParseMode));
        Skript.logEx();
        Skript.logEx("End of Error.");
        Skript.logEx();
        return new EmptyStacktraceException();
    }

    static void logEx() {
        SkriptLogger.LOGGER.severe(EXCEPTION_PREFIX);
    }

    static void logEx(String ... lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            SkriptLogger.LOGGER.severe(EXCEPTION_PREFIX + line);
            ++n2;
        }
    }

    public static void info(CommandSender sender, String info) {
        sender.sendMessage(String.valueOf(SKRIPT_PREFIX) + Utils.replaceEnglishChatStyles(info));
    }

    public static void broadcast(String message, String permission) {
        Bukkit.broadcast((String)(String.valueOf(SKRIPT_PREFIX) + Utils.replaceEnglishChatStyles(message)), (String)permission);
    }

    public static void adminBroadcast(String message) {
        Bukkit.broadcast((String)(String.valueOf(SKRIPT_PREFIX) + Utils.replaceEnglishChatStyles(message)), (String)"skript.admin");
    }

    public static void message(CommandSender sender, String info) {
        sender.sendMessage(Utils.replaceEnglishChatStyles(info));
    }

    public static void error(CommandSender sender, String error) {
        sender.sendMessage(String.valueOf(SKRIPT_PREFIX) + ChatColor.DARK_RED + Utils.replaceEnglishChatStyles(error));
    }

    @Nullable
    public SkriptUpdater getUpdater() {
        return this.updater;
    }
}

