/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions.base;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Converters;
import org.bukkit.event.Event;

public abstract class PropertyExpression<F, T>
extends SimpleExpression<T> {
    private Expression<? extends F> expr;

    public static <T> void register(Class<? extends Expression<T>> c, Class<T> type, String property, String fromType) {
        Skript.registerExpression(c, type, ExpressionType.PROPERTY, "[the] " + property + " of %" + fromType + "%", "%" + fromType + "%'[s] " + property);
    }

    protected final void setExpr(Expression<? extends F> expr) {
        this.expr = expr;
    }

    public final Expression<? extends F> getExpr() {
        return this.expr;
    }

    @Override
    protected final T[] get(Event e) {
        return this.get(e, this.expr.getArray(e));
    }

    @Override
    public final T[] getAll(Event e) {
        return this.get(e, this.expr.getAll(e));
    }

    protected abstract T[] get(Event var1, F[] var2);

    protected T[] get(F[] source, Converter<? super F, ? extends T> converter) {
        assert (source != null);
        assert (converter != null);
        return Converters.convertUnsafe(source, this.getReturnType(), converter);
    }

    @Override
    public final boolean isSingle() {
        return this.expr.isSingle();
    }

    @Override
    public final boolean getAnd() {
        return this.expr.getAnd();
    }

    @Override
    public Expression<? extends T> simplify() {
        this.expr = this.expr.simplify();
        return this;
    }
}

