/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Player Skull")
@Description(value={"Gets a skull item representing a player. Skulls for other entities are provided by the aliases."})
@Examples(value={"give the victim's skull to the attacker", "set the block at the entity to the entity's skull"})
@Since(value="2.0")
public class ExprSkull
extends SimplePropertyExpression<Object, ItemType> {
    private static final ItemType playerSkull;
    private static final boolean newSkullOwner;

    static {
        ExprSkull.register(ExprSkull.class, ItemType.class, "skull", "offlineplayers");
        playerSkull = Aliases.javaItemType("player skull");
        newSkullOwner = Skript.methodExists(SkullMeta.class, "setOwningPlayer", OfflinePlayer.class);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    @Nullable
    public ItemType convert(Object o) {
        ItemType skull = playerSkull.clone();
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (newSkullOwner) {
            meta.setOwningPlayer((OfflinePlayer)o);
        } else {
            meta.setOwner(((OfflinePlayer)o).getName());
        }
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    @Override
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @Override
    protected String getPropertyName() {
        return "skull";
    }
}

