/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Player List Header and Footer")
@Description(value={"The message above and below the player list in the tab menu."})
@Examples(value={"set all players tab list header to \"Welcome to the Server!\"", "send \"%the player's tab list header%\" to player", "reset all players' tab list header"})
@Since(value="2.4")
@RequiredPlugins(value={"Minecraft 1.13 or newer"})
public class ExprPlayerlistHeaderFooter
extends SimplePropertyExpression<Player, String> {
    private static final int HEADER = 0;
    private static final int FOOTER = 1;
    private int mark;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !ExprPlayerlistHeaderFooter.class.desiredAssertionStatus();
        if (Skript.methodExists(Player.class, "setPlayerListHeaderFooter", String.class, String.class)) {
            PropertyExpression.register(ExprPlayerlistHeaderFooter.class, String.class, "(player|tab)[ ]list (header|1\u00a6footer) [(text|message)]", "players");
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.mark = parseResult.mark;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    @Nullable
    public String convert(Player player) {
        if (this.mark == 0) {
            return player.getPlayerListHeader();
        }
        if (this.mark == 1) {
            return player.getPlayerListFooter();
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: 
            case DELETE: 
            case RESET: {
                return CollectionUtils.array(String.class);
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        String text = delta == null ? "" : (String)delta[0];
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (this.mark == 0) {
                player.setPlayerListHeader(text);
            } else if (this.mark == 1) {
                player.setPlayerListFooter(text);
            }
            ++n2;
        }
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return "player list " + (this.mark == 0 ? "header" : (this.mark == 1 ? "footer" : ""));
    }
}

