/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.events.bukkit.ScriptEvent;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class EvtScript
extends SelfRegisteringSkriptEvent {
    private boolean load;
    @Nullable
    private Trigger t;

    static {
        Skript.registerEvent("Script Load/Unload", EvtScript.class, ScriptEvent.class, "[script] (load|init|enable)", "[script] (unload|stop|disable)").description("Called directly after the trigger is loaded, or directly before the whole script is unloaded.").examples("on load:", "\tset {running::%script%} to true", "on unload:", "\tset {running::%script%} to false").since("2.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.load = matchedPattern == 0;
        return true;
    }

    @Override
    public void register(Trigger t) {
        this.t = t;
        if (this.load) {
            t.execute(new ScriptEvent());
        }
    }

    @Override
    public void unregister(Trigger t) {
        assert (t == this.t);
        if (!this.load) {
            t.execute(new ScriptEvent());
        }
        this.t = null;
    }

    @Override
    public void unregisterAll() {
        if (!this.load && this.t != null) {
            this.t.execute(new ScriptEvent());
        }
        this.t = null;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "script " + (this.load ? "" : "un") + "load";
    }
}

