/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.Adjective;
import ch.njol.skript.localization.Language;
import ch.njol.skript.util.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.eclipse.jdt.annotation.Nullable;

public enum SkriptColor implements Color
{
    BLACK(DyeColor.BLACK, ChatColor.BLACK),
    DARK_GREY(DyeColor.GRAY, ChatColor.DARK_GRAY),
    LIGHT_GREY(DyeColor.getByColor((org.bukkit.Color)org.bukkit.Color.fromRGB((int)0x9D9D97)), ChatColor.GRAY),
    WHITE(DyeColor.WHITE, ChatColor.WHITE),
    DARK_BLUE(DyeColor.BLUE, ChatColor.DARK_BLUE),
    BROWN(DyeColor.BROWN, ChatColor.BLUE),
    DARK_CYAN(DyeColor.CYAN, ChatColor.DARK_AQUA),
    LIGHT_CYAN(DyeColor.LIGHT_BLUE, ChatColor.AQUA),
    DARK_GREEN(DyeColor.GREEN, ChatColor.DARK_GREEN),
    LIGHT_GREEN(DyeColor.LIME, ChatColor.GREEN),
    YELLOW(DyeColor.YELLOW, ChatColor.YELLOW),
    ORANGE(DyeColor.ORANGE, ChatColor.GOLD),
    DARK_RED(DyeColor.RED, ChatColor.DARK_RED),
    LIGHT_RED(DyeColor.PINK, ChatColor.RED),
    DARK_PURPLE(DyeColor.PURPLE, ChatColor.DARK_PURPLE),
    LIGHT_PURPLE(DyeColor.MAGENTA, ChatColor.LIGHT_PURPLE);

    private ChatColor chat;
    private DyeColor dye;
    @Nullable
    Adjective adjective;
    static final Map<String, SkriptColor> names;
    static final Set<SkriptColor> colors;
    public static final String LANGUAGE_NODE = "colors";

    static {
        names = new HashMap<String, SkriptColor>();
        colors = new HashSet<SkriptColor>();
        colors.addAll(Arrays.asList(SkriptColor.values()));
        Language.addListener(() -> {
            names.clear();
            SkriptColor[] skriptColorArray = SkriptColor.values();
            int n = skriptColorArray.length;
            int n2 = 0;
            while (n2 < n) {
                SkriptColor color = skriptColorArray[n2];
                String node = "colors." + color.name();
                color.adjective = new Adjective(String.valueOf(node) + ".adjective");
                String[] stringArray = Language.getList(String.valueOf(node) + ".names");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray[n4];
                    names.put(name.toLowerCase(), color);
                    ++n4;
                }
                ++n2;
            }
        });
    }

    private SkriptColor(DyeColor dye, ChatColor chat) {
        this.chat = chat;
        this.dye = dye;
    }

    @Override
    public org.bukkit.Color asBukkitColor() {
        return this.dye.getColor();
    }

    @Nullable
    public Adjective getAdjective() {
        return this.adjective;
    }

    @Override
    public ChatColor asChatColor() {
        return this.chat;
    }

    @Override
    public DyeColor asDyeColor() {
        return this.dye;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getFormattedChat() {
        return "" + this.chat;
    }

    @Override
    @Deprecated
    public byte getWoolData() {
        return this.dye.getWoolData();
    }

    @Override
    @Deprecated
    public byte getDyeData() {
        return (byte)(15 - this.dye.getWoolData());
    }

    public static Optional<SkriptColor> fromName(String name) {
        return names.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(name)).map(Map.Entry::getValue).findAny();
    }

    public static Optional<SkriptColor> fromDyeColor(DyeColor dye) {
        return colors.stream().filter(color -> color.asDyeColor().equals((Object)dye)).findAny();
    }

    public static Optional<SkriptColor> fromBukkitColor(org.bukkit.Color color) {
        return colors.stream().filter(c -> c.asBukkitColor().equals((Object)color)).findAny();
    }

    @Deprecated
    public static Optional<SkriptColor> fromDyeData(short data) {
        if (data < 0 || data >= 16) {
            return Optional.empty();
        }
        return colors.stream().filter(color -> color.getWoolData() == 15 - data).findAny();
    }

    @Deprecated
    public static Optional<SkriptColor> fromWoolData(short data) {
        if (data < 0 || data >= 16) {
            return Optional.empty();
        }
        return colors.stream().filter(color -> color.getWoolData() == data).findAny();
    }

    public String toString() {
        return this.adjective == null ? this.name() : this.adjective.toString(-1, 0);
    }
}

