/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.variables.SerializedVariable;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.yggdrasil.Tag;
import ch.njol.yggdrasil.YggdrasilInputStream;
import ch.njol.yggdrasil.YggdrasilOutputStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Classes {
    @Nullable
    private static ClassInfo<?>[] classInfos = null;
    private static final List<ClassInfo<?>> tempClassInfos = new ArrayList();
    private static final HashMap<Class<?>, ClassInfo<?>> exactClassInfos = new HashMap();
    private static final HashMap<Class<?>, ClassInfo<?>> superClassInfos = new HashMap();
    private static final HashMap<String, ClassInfo<?>> classInfosByCodeName = new HashMap();
    private static final byte[] YGGDRASIL_START;
    private static final Charset UTF_8;

    static {
        byte[] byArray = new byte[6];
        byArray[0] = 89;
        byArray[1] = 103;
        byArray[2] = 103;
        byArray[5] = 1;
        YGGDRASIL_START = byArray;
        UTF_8 = Charset.forName("UTF-8");
    }

    private Classes() {
    }

    public static <T> void registerClass(ClassInfo<T> info) {
        try {
            Skript.checkAcceptRegistrations();
            if (classInfosByCodeName.containsKey(info.getCodeName())) {
                throw new IllegalArgumentException("Can't register " + info.getC().getName() + " with the code name " + info.getCodeName() + " because that name is already used by " + classInfosByCodeName.get(info.getCodeName()));
            }
            if (exactClassInfos.containsKey(info.getC())) {
                throw new IllegalArgumentException("Can't register the class info " + info.getCodeName() + " because the class " + info.getC().getName() + " is already registered");
            }
            if (info.getCodeName().length() > 50) {
                throw new IllegalArgumentException("The codename '" + info.getCodeName() + "' is too long to be saved in a database, the maximum length allowed is " + 50);
            }
            exactClassInfos.put(info.getC(), info);
            classInfosByCodeName.put(info.getCodeName(), info);
            tempClassInfos.add(info);
        }
        catch (RuntimeException e) {
            if (SkriptConfig.apiSoftExceptions.value().booleanValue()) {
                Skript.warning("Ignored an exception due to user configuration: " + e.getMessage());
            }
            throw e;
        }
    }

    public static void onRegistrationsStop() {
        Classes.sortClassInfos();
        for (ClassInfo<?> ci : Classes.getClassInfos()) {
            if (ci.getSerializeAs() == null) continue;
            ClassInfo<?> sa = Classes.getExactClassInfo(ci.getSerializeAs());
            if (sa == null) {
                Skript.error(String.valueOf(ci.getCodeName()) + "'s 'serializeAs' class is not registered");
                continue;
            }
            if (sa.getSerializer() != null) continue;
            Skript.error(String.valueOf(ci.getCodeName()) + "'s 'serializeAs' class is not serializable");
        }
        for (ClassInfo<?> ci : Classes.getClassInfos()) {
            Serializer<?> s = ci.getSerializer();
            if (s == null) continue;
            Variables.yggdrasil.registerClassResolver(s);
        }
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"})
    private static void sortClassInfos() {
        assert (classInfos == null);
        if (!Skript.testing() && SkriptConfig.addonSafetyChecks.value().booleanValue()) {
            Classes.removeNullElements();
        }
        block0: for (ClassInfo<?> ci : tempClassInfos) {
            Set<String> before = ci.before();
            if (before == null || before.isEmpty()) continue;
            for (ClassInfo<?> classInfo : tempClassInfos) {
                if (!before.contains(classInfo.getCodeName())) continue;
                classInfo.after().add(ci.getCodeName());
                before.remove(classInfo.getCodeName());
                if (before.isEmpty()) continue block0;
            }
        }
        for (ClassInfo<?> ci : tempClassInfos) {
            for (ClassInfo<?> ci2 : tempClassInfos) {
                if (ci == ci2 || !ci.getC().isAssignableFrom(ci2.getC())) continue;
                ci.after().add(ci2.getCodeName());
            }
        }
        for (ClassInfo<?> ci : tempClassInfos) {
            HashSet<String> s = new HashSet<String>();
            Set<String> set = ci.before();
            if (set != null) {
                for (String string : set) {
                    if (Classes.getClassInfoNoError(string) != null) continue;
                    s.add(string);
                }
                set.removeAll(s);
            }
            for (String string : ci.after()) {
                if (Classes.getClassInfoNoError(string) != null) continue;
                s.add(string);
            }
            ci.after().removeAll(s);
            if (s.isEmpty() || !Skript.testing()) continue;
            Skript.warning(String.valueOf(s.size()) + " dependency/ies could not be resolved for " + ci + ": " + StringUtils.join(s, ", "));
        }
        ArrayList classInfos = new ArrayList(tempClassInfos.size());
        boolean changed = true;
        while (changed) {
            changed = false;
            int i = 0;
            while (i < tempClassInfos.size()) {
                ClassInfo<?> classInfo = tempClassInfos.get(i);
                if (classInfo.after().isEmpty()) {
                    classInfos.add(classInfo);
                    tempClassInfos.remove(i);
                    --i;
                    for (ClassInfo classInfo2 : tempClassInfos) {
                        classInfo2.after().remove(classInfo.getCodeName());
                    }
                    changed = true;
                }
                ++i;
            }
        }
        Classes.classInfos = classInfos.toArray(new ClassInfo[classInfos.size()]);
        if (!tempClassInfos.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (ClassInfo<?> classInfo : tempClassInfos) {
                if (b.length() != 0) {
                    b.append(", ");
                }
                b.append(String.valueOf(classInfo.getCodeName()) + " (after: " + StringUtils.join(classInfo.after(), ", ") + ")");
            }
            throw new IllegalStateException("ClassInfos with circular dependencies detected: " + b.toString());
        }
        if (Skript.debug()) {
            StringBuilder b = new StringBuilder();
            for (ClassInfo classInfo : classInfos) {
                if (b.length() != 0) {
                    b.append(", ");
                }
                b.append(classInfo.getCodeName());
            }
            Skript.info("All registered classes in order: " + b.toString());
        }
    }

    private static void removeNullElements() {
        Iterator<ClassInfo<?>> it = tempClassInfos.iterator();
        while (it.hasNext()) {
            ClassInfo<?> ci = it.next();
            if (ci.getC() != null) continue;
            it.remove();
        }
    }

    private static void checkAllowClassInfoInteraction() {
        if (Skript.isAcceptRegistrations()) {
            throw new IllegalStateException("Cannot use classinfos until registration is over");
        }
    }

    public static List<ClassInfo<?>> getClassInfos() {
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<?>[] ci = classInfos;
        if (ci == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(ci));
    }

    public static ClassInfo<?> getClassInfo(String codeName) {
        ClassInfo<?> ci = classInfosByCodeName.get(codeName);
        if (ci == null) {
            throw new SkriptAPIException("No class info found for " + codeName);
        }
        return ci;
    }

    @Nullable
    public static ClassInfo<?> getClassInfoNoError(@Nullable String codeName) {
        return classInfosByCodeName.get(codeName);
    }

    @Nullable
    public static <T> ClassInfo<T> getExactClassInfo(@Nullable Class<T> c) {
        return exactClassInfos.get(c);
    }

    public static <T> ClassInfo<? super T> getSuperClassInfo(Class<T> c) {
        assert (c != null);
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<?> i = superClassInfos.get(c);
        if (i != null) {
            return i;
        }
        for (ClassInfo<?> ci : Classes.getClassInfos()) {
            if (!ci.getC().isAssignableFrom(c)) continue;
            if (!Skript.isAcceptRegistrations()) {
                superClassInfos.put(c, ci);
            }
            return ci;
        }
        assert (false);
        return null;
    }

    public static Class<?> getClass(String codeName) {
        Classes.checkAllowClassInfoInteraction();
        return Classes.getClassInfo(codeName).getC();
    }

    @Nullable
    public static ClassInfo<?> getClassInfoFromUserInput(String name) {
        Classes.checkAllowClassInfoInteraction();
        name = name.toLowerCase();
        for (ClassInfo<?> ci : Classes.getClassInfos()) {
            Pattern[] uip = ci.getUserInputPatterns();
            if (uip == null) continue;
            Pattern[] patternArray = uip;
            int n = uip.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = patternArray[n2];
                if (pattern.matcher(name).matches()) {
                    return ci;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nullable
    public static Class<?> getClassFromUserInput(String name) {
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<?> ci = Classes.getClassInfoFromUserInput(name);
        return ci == null ? null : ci.getC();
    }

    @Nullable
    public static DefaultExpression<?> getDefaultExpression(String codeName) {
        Classes.checkAllowClassInfoInteraction();
        return Classes.getClassInfo(codeName).getDefaultExpression();
    }

    @Nullable
    public static <T> DefaultExpression<T> getDefaultExpression(Class<T> c) {
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<T> ci = Classes.getExactClassInfo(c);
        return ci == null ? null : ci.getDefaultExpression();
    }

    @Nullable
    public static String getExactClassName(Class<?> c) {
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<?> ci = exactClassInfos.get(c);
        return ci == null ? null : ci.getCodeName();
    }

    @Nullable
    public static <T> T parseSimple(String s, Class<T> c, ParseContext context) {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            for (ClassInfo<?> info : Classes.getClassInfos()) {
                Parser<?> parser = info.getParser();
                if (parser == null || !parser.canParse(context) || !c.isAssignableFrom(info.getC())) continue;
                log.clear();
                Object t = parser.parse(s, context);
                if (t == null) continue;
                log.printLog();
                Object obj = t;
                return (T)obj;
            }
            log.printError();
        }
        finally {
            log.stop();
        }
        return null;
    }

    @Nullable
    public static <T> T parse(String s, Class<T> c, ParseContext context) {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T t = Classes.parseSimple(s, c, context);
            if (t != null) {
                log.printLog();
                T t2 = t;
                return t2;
            }
            for (Converter.ConverterInfo<?, ?> conv : Converters.getConverters()) {
                if (context == ParseContext.COMMAND && (conv.options & 4) != 0 || !c.isAssignableFrom(conv.to)) continue;
                log.clear();
                Object o = Classes.parseSimple(s, conv.from, context);
                if (o == null || (t = conv.converter.convert(o)) == null) continue;
                log.printLog();
                T t3 = t;
                return t3;
            }
            log.printError();
        }
        finally {
            log.stop();
        }
        return null;
    }

    @Nullable
    public static <T> Parser<? extends T> getParser(Class<T> to) {
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<?>[] classInfos = Classes.classInfos;
        if (classInfos == null) {
            return null;
        }
        int i = classInfos.length - 1;
        while (i >= 0) {
            ClassInfo<?> ci = classInfos[i];
            if (to.isAssignableFrom(ci.getC()) && ci.getParser() != null) {
                return ci.getParser();
            }
            --i;
        }
        for (Converter.ConverterInfo<?, ?> conv : Converters.getConverters()) {
            if (!to.isAssignableFrom(conv.to)) continue;
            int i2 = classInfos.length - 1;
            while (i2 >= 0) {
                ClassInfo<?> ci = classInfos[i2];
                Parser<?> parser = ci.getParser();
                if (conv.from.isAssignableFrom(ci.getC()) && parser != null) {
                    return Classes.createConvertedParser(parser, conv.converter);
                }
                --i2;
            }
        }
        return null;
    }

    @Nullable
    public static <T> Parser<? extends T> getExactParser(Class<T> c) {
        if (Skript.isAcceptRegistrations()) {
            for (ClassInfo<?> ci : tempClassInfos) {
                if (ci.getC() != c) continue;
                return ci.getParser();
            }
            return null;
        }
        ClassInfo<T> ci = Classes.getExactClassInfo(c);
        return ci == null ? null : ci.getParser();
    }

    private static <F, T> Parser<T> createConvertedParser(final Parser<?> parser, final Converter<F, T> converter) {
        return new Parser<T>(){

            @Override
            @Nullable
            public T parse(String s, ParseContext context) {
                Object f = parser.parse(s, context);
                if (f == null) {
                    return null;
                }
                return converter.convert(f);
            }

            @Override
            public String toString(T o, int flags) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String toVariableNameString(T o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getVariableNamePattern() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String toString(@Nullable Object o) {
        return Classes.toString(o, StringMode.MESSAGE, 0);
    }

    public static String getDebugMessage(@Nullable Object o) {
        return Classes.toString(o, StringMode.DEBUG, 0);
    }

    public static <T> String toString(@Nullable T o, StringMode mode) {
        return Classes.toString(o, mode, 0);
    }

    private static <T> String toString(@Nullable T o, StringMode mode, int flags) {
        assert (flags == 0 || mode == StringMode.MESSAGE);
        if (o == null) {
            return Language.get("none");
        }
        if (o.getClass().isArray()) {
            if (((Object[])o).length == 0) {
                return Language.get("none");
            }
            StringBuilder b = new StringBuilder();
            boolean first = true;
            Object[] objectArray = (Object[])o;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object i = objectArray[n2];
                if (!first) {
                    b.append(", ");
                }
                b.append(Classes.toString(i, mode, flags));
                first = false;
                ++n2;
            }
            return "[" + b.toString() + "]";
        }
        for (ClassInfo<?> ci : Classes.getClassInfos()) {
            Parser<?> parser = ci.getParser();
            if (parser == null || !ci.getC().isInstance(o)) continue;
            String s = mode == StringMode.MESSAGE ? parser.toString(o, flags) : (mode == StringMode.DEBUG ? "[" + ci.getCodeName() + ":" + parser.toString(o, mode) + "]" : parser.toString(o, mode));
            return s;
        }
        return mode == StringMode.VARIABLE_NAME ? "object:" + o : "" + o;
    }

    public static String toString(Object[] os, int flags, boolean and) {
        return Classes.toString(os, and, null, StringMode.MESSAGE, flags);
    }

    public static String toString(Object[] os, int flags, @Nullable ChatColor c) {
        return Classes.toString(os, true, c, StringMode.MESSAGE, flags);
    }

    public static String toString(Object[] os, boolean and) {
        return Classes.toString(os, and, null, StringMode.MESSAGE, 0);
    }

    public static String toString(Object[] os, boolean and, StringMode mode) {
        return Classes.toString(os, and, null, mode, 0);
    }

    private static String toString(Object[] os, boolean and, @Nullable ChatColor c, StringMode mode, int flags) {
        if (os.length == 0) {
            return Classes.toString(null);
        }
        if (os.length == 1) {
            return Classes.toString(os[0], mode, flags);
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < os.length) {
            if (i != 0) {
                if (c != null) {
                    b.append(c.toString());
                }
                if (i == os.length - 1) {
                    b.append(and ? " and " : " or ");
                } else {
                    b.append(", ");
                }
            }
            b.append(Classes.toString(os[i], mode, flags));
            ++i;
        }
        return b.toString();
    }

    private static byte[] getYggdrasilStart(ClassInfo<?> c) throws NotSerializableException {
        assert (Enum.class.isAssignableFrom(Kleenean.class) && Tag.getType(Kleenean.class) == Tag.T_ENUM) : Tag.getType(Kleenean.class);
        Tag t = Tag.getType(c.getC());
        assert (t.isWrapper() || t == Tag.T_STRING || t == Tag.T_OBJECT || t == Tag.T_ENUM);
        byte[] cn = t == Tag.T_OBJECT || t == Tag.T_ENUM ? Variables.yggdrasil.getID(c.getC()).getBytes(UTF_8) : null;
        byte[] r = new byte[YGGDRASIL_START.length + 1 + (cn == null ? 0 : 1 + cn.length)];
        int i = 0;
        while (i < YGGDRASIL_START.length) {
            r[i] = YGGDRASIL_START[i];
            ++i;
        }
        r[i++] = t.tag;
        if (cn != null) {
            r[i++] = (byte)cn.length;
            int j = 0;
            while (j < cn.length) {
                r[i++] = cn[j];
                ++j;
            }
        }
        assert (i == r.length);
        return r;
    }

    @Nullable
    public static SerializedVariable.Value serialize(@Nullable Object o) {
        Serializer<?> s;
        if (o == null) {
            return null;
        }
        assert (Bukkit.isPrimaryThread());
        ClassInfo<?> ci = Classes.getSuperClassInfo(o.getClass());
        if (ci.getSerializeAs() != null) {
            if ((ci = Classes.getExactClassInfo(ci.getSerializeAs())) == null) {
                assert (false) : o.getClass();
                return null;
            }
            if ((o = Converters.convert(o, ci.getC())) == null) {
                assert (false) : ci.getCodeName();
                return null;
            }
        }
        if ((s = ci.getSerializer()) == null) {
            return null;
        }
        assert (!s.mustSyncDeserialization() || Bukkit.isPrimaryThread());
        try {
            Object d;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            YggdrasilOutputStream yout = Variables.yggdrasil.newOutputStream(bout);
            yout.writeObject(o);
            yout.flush();
            yout.close();
            byte[] r = bout.toByteArray();
            byte[] start = Classes.getYggdrasilStart(ci);
            int i = 0;
            while (i < start.length) {
                assert (r[i] == start[i]) : o + " (" + ci.getC().getName() + "); " + Arrays.toString(start) + ", " + Arrays.toString(r);
                ++i;
            }
            byte[] r2 = new byte[r.length - start.length];
            System.arraycopy(r, start.length, r2, 0, r2.length);
            assert (Classes.equals(o, d = Classes.deserialize(ci, new ByteArrayInputStream(r2)))) : o + " (" + o.getClass() + ") != " + d + " (" + (d == null ? null : d.getClass()) + "): " + Arrays.toString(r);
            return new SerializedVariable.Value(ci.getCodeName(), r2);
        }
        catch (IOException e) {
            Skript.exception((Throwable)e, new String[0]);
            return null;
        }
    }

    private static boolean equals(@Nullable Object o, @Nullable Object d) {
        if (o instanceof Chunk) {
            if (!(d instanceof Chunk)) {
                return false;
            }
            Chunk c1 = (Chunk)o;
            Chunk c2 = (Chunk)d;
            return c1.getWorld().equals(c2.getWorld()) && c1.getX() == c2.getX() && c1.getZ() == c2.getZ();
        }
        return o == null ? d == null : o.equals(d);
    }

    @Nullable
    public static Object deserialize(ClassInfo<?> type, byte[] value) {
        return Classes.deserialize(type, new ByteArrayInputStream(value));
    }

    @Nullable
    public static Object deserialize(String type, byte[] value) {
        ClassInfo<?> ci = Classes.getClassInfoNoError(type);
        if (ci == null) {
            return null;
        }
        return Classes.deserialize(ci, new ByteArrayInputStream(value));
    }

    @Nullable
    public static Object deserialize(ClassInfo<?> type, InputStream value) {
        Serializer<?> s;
        assert ((s = type.getSerializer()) != null && (!s.mustSyncDeserialization() || Bukkit.isPrimaryThread())) : type + "; " + s + "; " + Bukkit.isPrimaryThread();
        Closeable in = null;
        try {
            value = new SequenceInputStream(new ByteArrayInputStream(Classes.getYggdrasilStart(type)), value);
            in = Variables.yggdrasil.newInputStream(value);
            Object object = ((YggdrasilInputStream)in).readObject();
            return object;
        }
        catch (IOException e) {
            if (Skript.testing()) {
                e.printStackTrace();
            }
            return null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            try {
                value.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Deprecated
    @Nullable
    public static Object deserialize(String type, String value) {
        assert (Bukkit.isPrimaryThread());
        ClassInfo<?> ci = Classes.getClassInfoNoError(type);
        if (ci == null) {
            return null;
        }
        Serializer<?> s = ci.getSerializer();
        if (s == null) {
            return null;
        }
        return s.deserialize(value);
    }
}

