/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTameEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Tamer")
@Description(value={"The tamer of an entity. Can only be used in entity tame events. You can use 'event-entity' to refer tamed entity itself."})
@Examples(value={"on tame:", "\tif the tamer is a player:", "\t\tsend \"someone tamed something!\" to console"})
@Since(value="2.2-dev25")
public class ExprTamer
extends SimpleExpression<Player> {
    static {
        Skript.registerExpression(ExprTamer.class, Player.class, ExpressionType.SIMPLE, "[the] tamer");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (!ScriptLoader.isCurrentEvent(EntityTameEvent.class)) {
            Skript.error("the expression 'tamer' may only be used in the entity tame event.");
            return false;
        }
        return true;
    }

    protected Player[] get(Event e) {
        return new Player[]{((EntityTameEvent)e).getOwner() instanceof Player ? (Player)((EntityTameEvent)e).getOwner() : null};
    }

    @Override
    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the tamer";
    }
}

