/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.util.slot.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Name / Display Name")
@Description(value={"Represents a player's minecraft account name, chat display name, or playerlist name, or the custom name of an item, en entity or an inventory.", "The differences between the different names are:", "<ul>", "<li>name: Minecraft account name of a player (unchangeable), or the custom name of an item or mob (changeable).</li>", "<li>display name: The name of a player as displayed in the chat and messages, e.g. when including %player% in a message. This name can be changed freely and can include colour codes, and is shared among all plugins (e.g. chat plugins will use a changed name).</li>", "<li>tab list name: The name of a player used in the player lists that usually opens with the tab key. Please note that this is limited to 16 characters, including colour codes which are counted as 2 characters each, and that no two players can have the same tab list name at the same time.</li>", "</ul>"})
@Examples(value={"on join:", "\tplayer has permission \"name.red\"", "\tset the player's display name to \"<red>[admin]<gold>%name of player%\"", "\tset the player's tablist name to \"<green>%name of player%\"", "set the name of the player's tool to \"Legendary Sword of Awesomeness\""})
@Since(value="1.4.6 (players' name & display name), <i>unknown</i> (player list name), 2.0 (item name), 2.2-dev20 (inventory name)")
public class ExprName
extends SimplePropertyExpression<Object, String> {
    private static final boolean inventoryTitles = Skript.methodExists(Inventory.class, "getTitle", new Class[0]);
    @Nullable
    static final MethodHandle TITLE_METHOD;
    static final int ITEMSTACK = 1;
    static final int ENTITY = 2;
    static final int PLAYER = 4;
    static final int INVENTORY = 8;
    static final String[] types;
    private NameType type;
    private int changeType = 0;

    static {
        MethodHandle _METHOD = null;
        try {
            _METHOD = MethodHandles.lookup().findVirtual(Inventory.class, "getName", MethodType.methodType(String.class));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        TITLE_METHOD = _METHOD;
        types = new String[]{"itemstacks/slots", "livingentities", "players", "inventories"};
        NameType[] nameTypeArray = NameType.values();
        int n = nameTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NameType n3 = nameTypeArray[n2];
            ExprName.register(ExprName.class, String.class, n3.pattern, n3.getFrom());
            ++n2;
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = NameType.values()[parseResult.mark];
        if (exprs[0] instanceof Variable) {
            this.setExpr(exprs[0].getConvertedExpression(Object.class));
        } else {
            this.setExpr(exprs[0]);
        }
        return true;
    }

    @Override
    public Class<String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return this.type.name;
    }

    @Override
    @Nullable
    public String convert(Object o) {
        return this.type.get(o instanceof Slot ? ((Slot)o).getItem() : o);
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE && (this.type.acceptChange & 0xFFFFFFFB) != 0 || mode == Changer.ChangeMode.RESET) {
            return new Class[0];
        }
        if (mode != Changer.ChangeMode.SET) {
            return null;
        }
        if ((this.type.acceptChange & 4) != 0 && Player.class.isAssignableFrom(this.getExpr().getReturnType())) {
            this.changeType = 4;
        } else if ((this.type.acceptChange & 1) != 0 && (this.getExpr().isSingle() && Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, ItemStack.class, ItemType.class) || Slot.class.isAssignableFrom(this.getExpr().getReturnType()))) {
            this.changeType = 1;
        } else if ((this.type.acceptChange & 2) != 0 && LivingEntity.class.isAssignableFrom(this.getExpr().getReturnType())) {
            if (this.type == NameType.NAME && Player.class.isAssignableFrom(this.getExpr().getReturnType())) {
                Skript.error("Cannot change the Minecraft name of a player. Change the 'display name of <player>' or 'tablist name of <player>' instead.");
                return null;
            }
            this.changeType = 2;
        }
        return this.changeType == 0 ? null : CollectionUtils.array(String.class);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        String name;
        String string = name = delta == null ? null : (String)delta[0];
        if (this.changeType == 1) {
            if (Slot.class.isAssignableFrom(this.getExpr().getReturnType())) {
                Slot[] slotArray = (Slot[])this.getExpr().getArray(e);
                int n = slotArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Slot s = slotArray[n2];
                    ItemStack i = s.getItem();
                    this.type.set(i, name);
                    s.setItem(i);
                    ++n2;
                }
            } else {
                Object i = this.getExpr().getSingle(e);
                if (i instanceof ItemType) {
                    this.type.set(i, name);
                    this.getExpr().change(e, new ItemType[]{(ItemType)i}, Changer.ChangeMode.SET);
                    return;
                }
                if (!(i instanceof ItemStack) && !(i instanceof Slot)) {
                    return;
                }
                ItemStack is = i instanceof Slot ? ((Slot)i).getItem() : (ItemStack)i;
                this.type.set(is, name);
                if (i instanceof Slot) {
                    ((Slot)i).setItem(is);
                } else if (Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, ItemStack.class)) {
                    this.getExpr().change(e, new Object[]{i}, Changer.ChangeMode.SET);
                } else {
                    this.getExpr().change(e, new ItemType[]{new ItemType((ItemStack)i)}, Changer.ChangeMode.SET);
                }
            }
        } else {
            F[] FArray = this.getExpr().getArray(e);
            int n = FArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object o = FArray[n3];
                if (o instanceof LivingEntity || o instanceof Player || o instanceof Inventory) {
                    this.type.set(o, name);
                }
                ++n3;
            }
        }
    }

    private static abstract class NameType
    extends Enum<NameType> {
        public static final /* enum */ NameType NAME = new NameType("name", "name[s]", 15, 3){

            @Override
            void set(@Nullable Object o, @Nullable String name) {
                if (o == null) {
                    return;
                }
                if (o instanceof LivingEntity) {
                    ((LivingEntity)o).setCustomName(name);
                    ((LivingEntity)o).setRemoveWhenFarAway(false);
                } else if (o instanceof ItemType) {
                    ItemMeta m = ((ItemType)o).getItemMeta();
                    m.setDisplayName(name);
                    ((ItemType)o).setItemMeta(m);
                } else if (o instanceof ItemStack) {
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    if (m != null) {
                        m.setDisplayName(name);
                        ((ItemStack)o).setItemMeta(m);
                    }
                } else if (o instanceof Inventory) {
                    Inventory inventory = (Inventory)o;
                    Inventory copy = inventory.getType() == InventoryType.CHEST ? (name != null ? Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (int)inventory.getSize(), (String)name) : Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (int)inventory.getSize())) : (name != null ? Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (InventoryType)inventory.getType(), (String)name) : Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (InventoryType)inventory.getType()));
                    copy.setContents(inventory.getContents());
                    inventory.getViewers().forEach(human -> {
                        InventoryView inventoryView = human.openInventory(copy);
                    });
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            String get(@Nullable Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof Player) {
                    return ((Player)o).getName();
                }
                if (o instanceof LivingEntity) {
                    return ((LivingEntity)o).getCustomName();
                }
                if (o instanceof ItemType) {
                    ItemMeta m = ((ItemType)o).getItemMeta();
                    return !m.hasDisplayName() ? null : m.getDisplayName();
                }
                if (o instanceof ItemStack) {
                    if (!((ItemStack)o).hasItemMeta()) {
                        return null;
                    }
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    return m == null || !m.hasDisplayName() ? null : m.getDisplayName();
                }
                if (o instanceof Inventory) {
                    if (TITLE_METHOD != null) {
                        try {
                            if (!$assertionsDisabled && TITLE_METHOD == null) {
                                throw new AssertionError();
                            }
                            return TITLE_METHOD.invoke(o);
                        }
                        catch (IllegalAccessException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            return null;
                        }
                        catch (Throwable e) {
                            Skript.exception(e, new String[0]);
                            return null;
                        }
                    }
                    return null;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
        public static final /* enum */ NameType DISPLAY_NAME = new NameType("display name", "(display|nick|chat)[ ]name[s]", 15, 7){

            @Override
            void set(@Nullable Object o, @Nullable String s) {
                if (o == null) {
                    return;
                }
                if (o instanceof Player) {
                    ((Player)o).setDisplayName(s == null ? ((Player)o).getName() : String.valueOf(s) + ChatColor.RESET);
                } else if (o instanceof LivingEntity) {
                    ((LivingEntity)o).setCustomName(s);
                    ((LivingEntity)o).setCustomNameVisible(s != null);
                    ((LivingEntity)o).setRemoveWhenFarAway(false);
                } else if (o instanceof ItemStack) {
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    if (m != null) {
                        m.setDisplayName(s);
                        ((ItemStack)o).setItemMeta(m);
                    }
                } else if (o instanceof Inventory) {
                    Inventory inventory = (Inventory)o;
                    Inventory copy = inventory.getType() == InventoryType.CHEST ? Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (int)inventory.getSize(), (String)this.name) : Bukkit.createInventory((InventoryHolder)inventory.getHolder(), (InventoryType)inventory.getType(), (String)this.name);
                    copy.setContents(inventory.getContents());
                    inventory.getViewers().forEach(human -> {
                        InventoryView inventoryView = human.openInventory(copy);
                    });
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            String get(@Nullable Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof Player) {
                    return ((Player)o).getDisplayName();
                }
                if (o instanceof LivingEntity) {
                    return ((LivingEntity)o).getCustomName();
                }
                if (o instanceof ItemStack) {
                    if (!((ItemStack)o).hasItemMeta()) {
                        return null;
                    }
                    ItemMeta m = ((ItemStack)o).getItemMeta();
                    return m == null || !m.hasDisplayName() ? null : m.getDisplayName();
                }
                if (o instanceof Inventory) {
                    if (TITLE_METHOD != null) {
                        try {
                            if (!$assertionsDisabled && TITLE_METHOD == null) {
                                throw new AssertionError();
                            }
                            return TITLE_METHOD.invoke(o);
                        }
                        catch (IllegalAccessException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            return null;
                        }
                        catch (Throwable e) {
                            Skript.exception(e, new String[0]);
                            return null;
                        }
                    }
                    return null;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
        public static final /* enum */ NameType TABLIST_NAME = new NameType("player list name", "(player|tab)[ ]list name[s]", 4, 4){

            @Override
            void set(@Nullable Object o, @Nullable String s) {
                if (o == null) {
                    return;
                }
                if (o instanceof Player) {
                    try {
                        ((Player)o).setPlayerListName(s == null ? "" : s);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            @Override
            @Nullable
            String get(@Nullable Object o) {
                if (o == null) {
                    return null;
                }
                if (o instanceof Player) {
                    return ((Player)o).getPlayerListName();
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
        final String name;
        final String pattern;
        final int from;
        final int acceptChange;
        private static final /* synthetic */ NameType[] ENUM$VALUES;

        static {
            ENUM$VALUES = new NameType[]{NAME, DISPLAY_NAME, TABLIST_NAME};
        }

        private NameType(String name, String pattern, int from, int change) {
            this.name = name;
            this.pattern = "(" + this.ordinal() + "\u00a6)" + pattern;
            this.from = from;
            this.acceptChange = change;
        }

        abstract void set(@Nullable Object var1, @Nullable String var2);

        @Nullable
        abstract String get(@Nullable Object var1);

        String getFrom() {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < types.length) {
                if ((this.from & 1 << i) != 0 && (1 << i != 1 || Skript.isRunningMinecraft(1, 4, 5)) && (1 << i != 2 || Skript.isRunningMinecraft(1, 5))) {
                    if (b.length() != 0) {
                        b.append("/");
                    }
                    b.append(types[i]);
                }
                ++i;
            }
            return "" + b;
        }

        public static NameType[] values() {
            NameType[] nameTypeArray = ENUM$VALUES;
            int n = nameTypeArray.length;
            NameType[] nameTypeArray2 = new NameType[n];
            System.arraycopy(ENUM$VALUES, 0, nameTypeArray2, 0, n);
            return nameTypeArray2;
        }

        public static NameType valueOf(String string) {
            return Enum.valueOf(NameType.class, string);
        }
    }
}

