/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerListPingEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Max Players")
@Description(value={"The count of max players. This can be changed in a <a href='events.html#server_list_ping'>server list ping</a> event only.", "'real max players' returns the real count of max players of the server always and can't be changed."})
@Examples(value={"on server list ping:", "\tset the max players count to (online players count + 1)"})
@Since(value="2.3")
public class ExprMaxPlayers
extends SimpleExpression<Number> {
    private static final boolean PAPER_EVENT_EXISTS;
    private boolean isReal;

    static {
        Skript.registerExpression(ExprMaxPlayers.class, Number.class, ExpressionType.PROPERTY, "[the] [(1\u00a6(real|default)|2\u00a6(fake|shown|displayed))] max[imum] player[s] [(count|amount|number|size)]", "[the] [(1\u00a6(real|default)|2\u00a6(fake|shown|displayed))] max[imum] (count|amount|number|size) of players");
        PAPER_EVENT_EXISTS = Skript.classExists("com.destroystokyo.paper.event.server.PaperServerListPingEvent");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        boolean isServerPingEvent;
        boolean bl = isServerPingEvent = ScriptLoader.isCurrentEvent(ServerListPingEvent.class) || PAPER_EVENT_EXISTS && ScriptLoader.isCurrentEvent(PaperServerListPingEvent.class);
        if (parseResult.mark == 2 && !isServerPingEvent) {
            Skript.error("The 'shown' max players count expression can't be used outside of a server list ping event");
            return false;
        }
        this.isReal = parseResult.mark == 0 && !isServerPingEvent || parseResult.mark == 1;
        return true;
    }

    @Nullable
    public Number[] get(Event e) {
        if (this.isReal) {
            return CollectionUtils.array(Bukkit.getMaxPlayers());
        }
        return CollectionUtils.array(((ServerListPingEvent)e).getMaxPlayers());
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (!this.isReal) {
            if (ScriptLoader.hasDelayBefore.isTrue()) {
                Skript.error("Can't change the fake max players count anymore after the server list ping event has already passed");
                return null;
            }
            switch (mode) {
                case ADD: 
                case SET: 
                case REMOVE: 
                case DELETE: 
                case RESET: {
                    return CollectionUtils.array(Number.class);
                }
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        ServerListPingEvent event = (ServerListPingEvent)e;
        switch (mode) {
            case SET: {
                event.setMaxPlayers(((Number)delta[0]).intValue());
                break;
            }
            case ADD: {
                event.setMaxPlayers(event.getMaxPlayers() + ((Number)delta[0]).intValue());
                break;
            }
            case REMOVE: {
                event.setMaxPlayers(event.getMaxPlayers() - ((Number)delta[0]).intValue());
                break;
            }
            case DELETE: 
            case RESET: {
                event.setMaxPlayers(Bukkit.getMaxPlayers());
            }
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the count of " + (this.isReal ? "real max players" : "max players");
    }
}

