/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Coloured / Uncoloured")
@Description(value={"Parses &lt;colour&gt;s and, optionally, chat styles in a message or removes", "any colours <i>and</i> chat styles from the message. Parsing all", "chat styles requires this expression to be used in same line with", "the <a href=effects.html#EffSend>send effect</a>."})
@Examples(value={"on chat:", "\tset message to coloured message # Safe; only colors get parsed", "command /fade &lt;player&gt;:", "\ttrigger:", "\t\tset display name of the player-argument to uncoloured display name of the player-argument", "command /format &lt;text&gt;:", "\ttrigger:", "\t\tmessage formatted text-argument # Safe, because we're sending to whoever used this command"})
@Since(value="2.0")
public class ExprColoured
extends PropertyExpression<String, String> {
    boolean color;
    boolean format;

    static {
        Skript.registerExpression(ExprColoured.class, String.class, ExpressionType.COMBINED, "(colo[u]r-|colo[u]red )%strings%", "(format-|formatted )%strings%", "(un|non)[-](colo[u]r-|colo[u]red |format-|formatted )%strings%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.color = matchedPattern <= 1;
        this.format = matchedPattern == 1;
        return true;
    }

    protected String[] get(Event e, String[] source) {
        return this.get(source, new Converter<String, String>(){

            @Override
            public String convert(String s) {
                return ExprColoured.this.color ? Utils.replaceChatStyles(s) : ChatMessages.stripStyles(s);
            }
        });
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.color ? "" : "un") + "coloured " + this.getExpr().toString(e, debug);
    }

    public boolean isUnsafeFormat() {
        return this.format;
    }
}

