/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.localization.Adjective;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class ThrownPotionData
extends EntityData<ThrownPotion> {
    private static final Adjective m_adjective;
    @Nullable
    private ItemType[] types;

    static {
        EntityData.register(ThrownPotionData.class, "thrown potion", ThrownPotion.class, "thrown potion");
        m_adjective = new Adjective("entities.thrown potion.adjective");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (exprs.length > 0 && exprs[0] != null && Converters.convert((ItemType[])exprs[0].getAll(), ItemType.class, new Converter<ItemType, ItemType>(){

            @Override
            @Nullable
            public ItemType convert(ItemType t) {
                ItemType r = null;
                for (ItemData d : t.getTypes()) {
                    if (d.getType() != Material.POTION) continue;
                    if (r == null) {
                        r = new ItemType(d);
                        continue;
                    }
                    r.add(d);
                }
                return r;
            }
        }).length == 0) {
            return false;
        }
        return false;
    }

    @Override
    protected boolean init(@Nullable Class<? extends ThrownPotion> c, @Nullable ThrownPotion e) {
        if (e != null) {
            ItemStack i = e.getItem();
            if (i == null) {
                return false;
            }
            this.types = new ItemType[]{new ItemType(i)};
        }
        return true;
    }

    @Override
    protected boolean match(ThrownPotion entity) {
        if (this.types != null) {
            ItemType[] itemTypeArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                ItemType t = itemTypeArray[n2];
                if (t.isOfType(entity.getItem())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    @Override
    public void set(ThrownPotion entity) {
        if (this.types != null) {
            ItemType t = CollectionUtils.getRandom(this.types);
            assert (t != null);
            ItemStack i = t.getRandom();
            if (i == null) {
                return;
            }
            entity.setItem(i);
        }
    }

    @Override
    public Class<? extends ThrownPotion> getType() {
        return ThrownPotion.class;
    }

    @Override
    public EntityData getSuperType() {
        return new ThrownPotionData();
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (!(e instanceof ThrownPotionData)) {
            return false;
        }
        ThrownPotionData d = (ThrownPotionData)e;
        if (this.types != null) {
            return d.types != null && ItemType.isSubset(this.types, d.types);
        }
        return true;
    }

    @Override
    public String toString(int flags) {
        Object[] types = this.types;
        if (types == null) {
            return super.toString(flags);
        }
        StringBuilder b = new StringBuilder();
        b.append(Noun.getArticleWithSpace(types[0].getTypes().get(0).getGender(), flags));
        b.append(m_adjective.toString(types[0].getTypes().get(0).getGender(), flags));
        b.append(" ");
        b.append(Classes.toString(types, flags & 0xFFFFFFF9, false));
        return b.toString();
    }

    @Override
    @Deprecated
    protected boolean deserialize(String s) {
        throw new UnsupportedOperationException("old serialization is no longer supported");
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof ThrownPotionData)) {
            return false;
        }
        return Arrays.equals(this.types, ((ThrownPotionData)obj).types);
    }

    @Override
    protected int hashCode_i() {
        return Arrays.hashCode(this.types);
    }
}

