/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Rotate Around Vector")
@Description(value={"Rotates a vector around another vector"})
@Examples(value={"rotate {_v} around vector 1, 0, 0 by 90"})
@Since(value="2.2-dev28")
public class EffVectorRotateAroundAnother
extends Effect {
    private Expression<Vector> first;
    private Expression<Vector> second;
    private Expression<Number> degree;

    static {
        Skript.registerEffect(EffVectorRotateAroundAnother.class, "rotate %vectors% around %vector% by %number% [degrees]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.first = exprs[0];
        this.second = exprs[1];
        this.degree = exprs[2];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Vector v2 = this.second.getSingle(e);
        Number d = this.degree.getSingle(e);
        if (v2 == null || d == null) {
            return;
        }
        Vector[] vectorArray = this.first.getArray(e);
        int n = vectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Vector v1 = vectorArray[n2];
            VectorMath.rot(v1, v2, d.doubleValue());
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "rotate " + this.first.toString(e, debug) + " around " + this.second.toString(e, debug) + " by " + this.degree + "degrees";
    }
}

