/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.function.ExprFunctionCall;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.registrations.Converters;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Contains")
@Description(value={"Checks whether an inventory contains the given item, a text contains another piece of text, or a list of objects (e.g. a {list variable::*}) contains another object."})
@Examples(value={"block contains 20 cobblestone", "player has 4 flint and 2 iron ingots"})
@Since(value="1.0")
public class CondContains
extends Condition {
    private Expression<?> containers;
    private Expression<?> items;

    static {
        Skript.registerCondition(CondContains.class, "%inventories% ha(s|ve) %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories/strings/objects% contain[s] %itemtypes/strings/objects%", "%inventories% do[es](n't| not) have %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories/strings/objects% do[es](n't| not) contain %itemtypes/strings/objects%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.containers = exprs[0].getConvertedExpression(Object.class);
        if (this.containers == null) {
            return false;
        }
        if (!(this.containers instanceof Variable || String.class.isAssignableFrom(this.containers.getReturnType()) || Inventory.class.isAssignableFrom(this.containers.getReturnType()) || this.containers.getReturnType().equals(Object.class))) {
            ParseLogHandler h = SkriptLogger.startParseLogHandler();
            try {
                Expression c = this.containers.getConvertedExpression(String.class);
                if (c == null) {
                    c = this.containers.getConvertedExpression(Inventory.class);
                }
                if (c == null) {
                    h.printError();
                    return false;
                }
                this.containers = c;
                h.printLog();
            }
            finally {
                h.stop();
            }
        }
        this.items = exprs[1].getConvertedExpression(Object.class);
        if (this.items == null) {
            return false;
        }
        this.setNegated(matchedPattern >= 2);
        return true;
    }

    @Override
    public boolean check(Event e) {
        boolean caseSensitive = SkriptConfig.caseSensitive.value();
        return this.containers.check(e, container -> {
            if ((this.containers instanceof Variable || this.containers instanceof ExprFunctionCall) && !this.containers.isSingle()) {
                Object[] all = this.containers.getAll(e);
                return this.items.check(e, item -> {
                    Object[] objectArray2 = all;
                    int n = all.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray2[n2];
                        if (Comparator.Relation.EQUAL.is(Comparators.compare(o, item))) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                });
            }
            if (container instanceof Inventory) {
                Inventory invi = (Inventory)container;
                return this.items.check(e, type -> {
                    if (type instanceof ItemType) {
                        return ((ItemType)type).isContainedIn((Iterable<ItemStack>)invi);
                    }
                    if (type instanceof ItemStack) {
                        return invi.contains((ItemStack)type);
                    }
                    return false;
                });
            }
            if (container instanceof String) {
                String s = (String)container;
                return this.items.check(e, type -> {
                    String toFind;
                    if (type instanceof Variable && (toFind = (String)((Variable)type).getSingle(e)) != null) {
                        return StringUtils.contains(s, toFind, caseSensitive);
                    }
                    return type instanceof String && StringUtils.contains(s, (String)type, caseSensitive);
                });
            }
            Object val = container instanceof Variable ? ((Variable)container).getSingle(e) : container;
            Inventory invi = Converters.convert(val, Inventory.class);
            if (invi != null) {
                return this.items.check(e, type -> {
                    if (type instanceof ItemType) {
                        return ((ItemType)type).isContainedIn((Iterable<ItemStack>)invi);
                    }
                    if (type instanceof ItemStack) {
                        return invi.contains((ItemStack)type);
                    }
                    return false;
                });
            }
            String s = Converters.convert(val, String.class);
            if (s != null) {
                return this.items.check(e, type -> {
                    String toFind;
                    if (type instanceof Variable && (toFind = (String)((Variable)type).getSingle(e)) != null) {
                        return StringUtils.contains(s, toFind, caseSensitive);
                    }
                    return type instanceof String && StringUtils.contains(s, (String)type, caseSensitive);
                });
            }
            return false;
        }, this.isNegated());
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.containers.toString(e, debug)) + (this.isNegated() ? " doesn't contain " : " contains ") + this.items.toString(e, debug);
    }
}

