/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Vector from Pitch and Yaw")
@Description(value={"Creates a vector from a yaw and pitch value."})
@Examples(value={"set {_v} to vector from yaw 45 and pitch 45"})
@Since(value="2.2-dev28")
public class ExprVectorFromYawAndPitch
extends SimpleExpression<Vector> {
    private Expression<Number> pitch;
    private Expression<Number> yaw;

    static {
        Skript.registerExpression(ExprVectorFromYawAndPitch.class, Vector.class, ExpressionType.SIMPLE, "[a] [new] vector (from|with) yaw %number% and pitch %number%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.yaw = exprs[0];
        this.pitch = exprs[1];
        return true;
    }

    protected Vector[] get(Event e) {
        Number y = this.yaw.getSingle(e);
        Number p = this.pitch.getSingle(e);
        if (y == null || p == null) {
            return null;
        }
        float yaw = VectorMath.fromSkriptYaw(VectorMath.wrapAngleDeg(y.floatValue()));
        float pitch = VectorMath.fromSkriptPitch(VectorMath.wrapAngleDeg(p.floatValue()));
        return CollectionUtils.array(VectorMath.fromYawAndPitch(yaw, pitch));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "vector from yaw " + this.yaw.toString(e, debug) + " and pitch " + this.pitch.toString(e, debug);
    }
}

