/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Vector Between Locations")
@Description(value={"Creates a vector between two locations."})
@Examples(value={"set {_v} to vector between {_loc1} and {_loc2}"})
@Since(value="2.2-dev28")
public class ExprVectorBetweenLocations
extends SimpleExpression<Vector> {
    private Expression<Location> from;
    private Expression<Location> to;

    static {
        Skript.registerExpression(ExprVectorBetweenLocations.class, Vector.class, ExpressionType.SIMPLE, "[the] vector (from|between) %location% (to|and) %location%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.from = exprs[0];
        this.to = exprs[1];
        return true;
    }

    protected Vector[] get(Event e) {
        Location l1 = this.from.getSingle(e);
        Location l2 = this.to.getSingle(e);
        if (l1 == null || l2 == null) {
            return null;
        }
        return CollectionUtils.array(new Vector(l2.getX() - l1.getX(), l2.getY() - l1.getY(), l2.getZ() - l1.getZ()));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "vector from " + this.from.toString(e, debug) + " to " + this.to.toString(e, debug);
    }
}

