/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import java.util.Random;
import org.bukkit.TreeSpecies;
import org.bukkit.entity.Boat;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class BoatData
extends EntityData<Boat> {
    private static final ItemType oakBoat;
    private static final ItemType spruceBoat;
    private static final ItemType birchBoat;
    private static final ItemType jungleBoat;
    private static final ItemType acaciaBoat;
    private static final ItemType darkOakBoat;

    static {
        if (Skript.methodExists(Boat.class, "getWoodType", new Class[0])) {
            EntityData.register(BoatData.class, "boat", Boat.class, 0, "boat", "any boat", "oak boat", "spruce boat", "birch boat", "jungle boat", "acacia boat", "dark oak boat");
        }
        oakBoat = Aliases.javaItemType("oak boat");
        spruceBoat = Aliases.javaItemType("spruce boat");
        birchBoat = Aliases.javaItemType("birch boat");
        jungleBoat = Aliases.javaItemType("jungle boat");
        acaciaBoat = Aliases.javaItemType("acacia boat");
        darkOakBoat = Aliases.javaItemType("dark oak boat");
    }

    public BoatData() {
        this(0);
    }

    public BoatData(@Nullable TreeSpecies type) {
        this(type != null ? type.ordinal() + 2 : 1);
    }

    private BoatData(int type) {
        this.matchedPattern = type;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Boat> c, @Nullable Boat e) {
        if (e != null) {
            this.matchedPattern = 2 + e.getWoodType().ordinal();
        }
        return true;
    }

    @Override
    public void set(Boat entity) {
        if (this.matchedPattern == 1) {
            this.matchedPattern += new Random().nextInt(TreeSpecies.values().length);
        }
        if (this.matchedPattern > 1) {
            entity.setWoodType(TreeSpecies.values()[this.matchedPattern - 2]);
        }
    }

    @Override
    protected boolean match(Boat entity) {
        return this.matchedPattern <= 1 || entity.getWoodType().ordinal() == this.matchedPattern - 2;
    }

    @Override
    public Class<? extends Boat> getType() {
        return Boat.class;
    }

    @Override
    public EntityData getSuperType() {
        return new BoatData(this.matchedPattern);
    }

    @Override
    protected int hashCode_i() {
        return this.matchedPattern <= 1 ? 0 : this.matchedPattern;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (obj instanceof BoatData) {
            return this.matchedPattern == ((BoatData)obj).matchedPattern;
        }
        return false;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof BoatData) {
            return this.matchedPattern <= 1 || this.matchedPattern == ((BoatData)e).matchedPattern;
        }
        return false;
    }

    public boolean isOfItemType(ItemType i) {
        if (i.getRandom() == null) {
            return false;
        }
        int ordinal = -1;
        ItemStack stack = i.getRandom();
        if (oakBoat.isOfType(stack)) {
            ordinal = 0;
        } else if (spruceBoat.isOfType(stack)) {
            ordinal = TreeSpecies.REDWOOD.ordinal();
        } else if (birchBoat.isOfType(stack)) {
            ordinal = TreeSpecies.BIRCH.ordinal();
        } else if (jungleBoat.isOfType(stack)) {
            ordinal = TreeSpecies.JUNGLE.ordinal();
        } else if (acaciaBoat.isOfType(stack)) {
            ordinal = TreeSpecies.ACACIA.ordinal();
        } else if (darkOakBoat.isOfType(stack)) {
            ordinal = TreeSpecies.DARK_OAK.ordinal();
        }
        return this.hashCode_i() == ordinal + 2 || this.matchedPattern + ordinal == 2 || ordinal == 0;
    }
}

