/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptCommand;
import ch.njol.skript.config.Config;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.FileUtils;
import ch.njol.util.Kleenean;
import java.io.File;
import java.io.IOException;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Enable/Disable/Reload Script File")
@Description(value={"Enables, disables, or reloads a script file."})
@Examples(value={"reload script \"test\"", "enable script file \"testing\"", "unload script file \"script.sk\""})
@Since(value="2.4")
public class EffScriptFile
extends Effect {
    private static final int ENABLE = 1;
    private static final int RELOAD = 2;
    private static final int DISABLE = 3;
    private int mark;
    @Nullable
    private Expression<String> fileName;

    static {
        Skript.registerEffect(EffScriptFile.class, "(1\u00a6enable|1\u00a6load|2\u00a6reload|3\u00a6disable|3\u00a6unload) s(c|k)ript [file] %string%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.mark = parseResult.mark;
        this.fileName = exprs[0];
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.mark == 1 ? "enable" : (this.mark == 2 ? "disable" : (this.mark == 3 ? "unload" : ""))) + " script file " + (this.fileName != null ? this.fileName.toString(e, debug) : "");
    }

    @Override
    protected void execute(Event e) {
        String name = this.fileName != null ? this.fileName.getSingle(e) : "";
        File f = SkriptCommand.getScriptFromName(name != null ? name : "");
        if (f == null) {
            return;
        }
        switch (this.mark) {
            case 1: {
                if (!f.getName().startsWith("-")) {
                    return;
                }
                try {
                    f = FileUtils.move(f, new File(f.getParentFile(), f.getName().substring(1)), false);
                }
                catch (IOException ex) {
                    Skript.exception((Throwable)ex, "Error while enabling script file: " + name);
                    return;
                }
                Config config = ScriptLoader.loadStructure(f);
                ScriptLoader.loadScripts(config);
                break;
            }
            case 2: {
                if (f.getName().startsWith("-")) {
                    return;
                }
                if (!ScriptLoader.isAsync()) {
                    ScriptLoader.unloadScript(f);
                }
                Config config = ScriptLoader.loadStructure(f);
                ScriptLoader.loadScripts(config);
                break;
            }
            case 3: {
                if (f.getName().startsWith("-")) {
                    return;
                }
                ScriptLoader.unloadScript(f);
                try {
                    FileUtils.move(f, new File(f.getParentFile(), "-" + f.getName()), false);
                    break;
                }
                catch (IOException ex) {
                    Skript.exception((Throwable)ex, "Error while disabling script file: " + name);
                    return;
                }
            }
            default: {
                assert (false);
                return;
            }
        }
    }
}

